package com.atlassian.confluence.extra.flyingpdf.impl;

import com.atlassian.confluence.plugin.webresource.ConfluenceWebResourceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.CssWebResource;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceFilter;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import org.springframework.stereotype.Component;

/**
 * The resource manager used in a PDF context.
 */
@Component
public class PdfResourceManager {
    private static final WebResourceFilter CSS_FILTER = new CssWebResource();
    private static final WebResourceFilter PDF_RESOURCE_FILTER = s -> (CSS_FILTER.matches(s) && !s.endsWith("css/batch.css") && !"_super.css".equals(s));

    private final ConfluenceWebResourceManager webResourceManager;

    public PdfResourceManager(@ComponentImport ConfluenceWebResourceManager webResourceManager) {
        this.webResourceManager = webResourceManager;
    }

    /**
     * Add additional resources specifically for PDF export
     */
    public void requireResourcesForPdf() {
        webResourceManager.requireResourcesForContext("pdf-export");
    }

    /**
     * Returns the html tags for the resources to be included in the PDF export.
     * <p>
     * It only allows for CSS resources, excluding the super batch css provided by Confluence.
     * @return the resource
     */
    @HtmlSafe
    public String getResources() {
        return webResourceManager.getRequiredResources(UrlMode.AUTO, PDF_RESOURCE_FILTER);
    }

}
