package com.atlassian.confluence.extra.flyingpdf.impl;

import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.opensymphony.webwork.ServletActionContext;

/**
 * Action, which handles "build content tree for export customisation" (when user chooses "Custom Export" option on
 * "Export PDF Options" tab) requests from users.
 *
 * @since 3.4.5
 */
public class ContentTreeForExportSpaceAction extends BetterExportSpaceAction {
    @PermittedMethods(HttpMethod.GET)
    @Override
    public String execute() {
        ContentTreeLongRunningTask contentTreeLongRunningTask =
                pdfExportLongRunningTaskFactory.createNewContentTreeLongRunningTask(getI18n(), getSpace(),
                        getAuthenticatedUser(), servletRequest.getContextPath());

        taskId = longRunningTaskManager.startLongRunningTask(getAuthenticatedUser(), contentTreeLongRunningTask);
        ServletActionContext.getResponse().setContentType("text/xml");
        return SUCCESS;
    }
}
