package com.atlassian.confluence.extra.flyingpdf.html;

import com.atlassian.confluence.importexport.ImportExportException;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

/**
 * A convenience wrapper around a DOMParser.
 */
public class HtmlToDomParser {
    private final DOMParser parser;
    private StringBuffer collectedStyles;

    public HtmlToDomParser(DOMParser parser) {
        this.parser = parser;
        try {
            this.collectedStyles = (StringBuffer) parser.getProperty(HtmlConverterUtils.STYLECOLLECTOR_KEY);
        } catch (SAXException e) {
        }
    }

    public Document parse(String html) throws ImportExportException {
        return parse(new StringReader(html));
    }

    Document parse(Reader reader) throws ImportExportException {
        try {
            parser.parse(new InputSource(reader));
        } catch (SAXException ex) {
            throw new ImportExportException(ex);
        } catch (IOException ex) {
            throw new ImportExportException(ex);
        }

        Document dom = parser.getDocument();
        injectCollectedStyles(dom);
        return dom;
    }

    private void injectCollectedStyles(Document dom) {
        if (collectedStyles != null && collectedStyles.length() > 0) {
            NodeList styleNodes = dom.getElementsByTagName("style");
            if (styleNodes.getLength() > 0) {
                Node styleInHead = styleNodes.item(0);
                String styles = styleInHead.getTextContent();
                styleInHead.setTextContent(styles + "\r\n" + collectedStyles);
            }
        }
    }
}