package com.atlassian.confluence.extra.flyingpdf.config;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;

public class GlobalConfigurePdfExportStyleSheet extends AbstractConfigurePdfExportAction {
    private String style;

    public String getStyle() {
        return pdfSettings.getStyle(getBandanaContext());
    }

    public void setStyle(String style) {
        this.style = style;
    }

    @PermittedMethods({HttpMethod.GET, HttpMethod.POST})
    @XsrfProtectionExcluded
    public String execute() {
        return SUCCESS;
    }

    public String doEdit() {
        pdfSettings.setStyle(getBandanaContext(), style);
        return SUCCESS;
    }
}
