package com.atlassian.confluence.extra.flyingpdf.config;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class DefaultPdfExportSettingsManager implements PdfExportSettingsManager {

    private static final String STYLESHEET_KEY = "com.atlassian.confluence.extra.flyingpdf.config.style";
    private static final String TITLEPAGE_KEY = "com.atlassian.confluence.extra.flyingpdf.config.titlepage";
    private static final String HEADER_KEY = "com.atlassian.confluence.extra.flyingpdf.config.header";
    private static final String FOOTER_KEY = "com.atlassian.confluence.extra.flyingpdf.config.footer";

    private static final Logger log = Logger.getLogger(DefaultPdfExportSettingsManager.class);

    private final BandanaManager bandanaManager;

    public DefaultPdfExportSettingsManager(@ComponentImport BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    /* (non-Javadoc)
     * @see com.atlassian.confluence.extra.flyingpdf.config.PdfExportSettingsManager#getStyleForSpace(com.atlassian.confluence.spaces.Space)
     */
    public String getStyle(BandanaContext context) {
        return (String) bandanaManager.getValue(context, STYLESHEET_KEY);
    }

    /* (non-Javadoc)
     * @see com.atlassian.confluence.extra.flyingpdf.config.PdfExportSettingsManager#setStyleForSpace(com.atlassian.confluence.spaces.Space, java.lang.String)
     */
    public void setStyle(BandanaContext context, String value) {
        value = nullOutIfEmpty(value);
        bandanaManager.setValue(context, STYLESHEET_KEY, value);
    }

    public String getFooter(BandanaContext context) {
        return (String) bandanaManager.getValue(context, FOOTER_KEY);
    }

    public String getHeader(BandanaContext context) {
        return (String) bandanaManager.getValue(context, HEADER_KEY);
    }

    public String getTitlePage(BandanaContext context) {
        return (String) bandanaManager.getValue(context, TITLEPAGE_KEY);
    }

    public void setFooter(BandanaContext context, String value) {
        value = nullOutIfEmpty(value);
        bandanaManager.setValue(context, FOOTER_KEY, value);
    }

    public void setHeader(BandanaContext context, String value) {
        value = nullOutIfEmpty(value);
        bandanaManager.setValue(context, HEADER_KEY, value);
    }

    public void setTitlePage(BandanaContext context, String value) {
        value = nullOutIfEmpty(value);
        bandanaManager.setValue(context, TITLEPAGE_KEY, value);
    }

    /**
     * Used to null out the value before being saved to bandana. This is important so empty space settings
     * inherit the global setting.
     *
     * @param value
     * @return
     */
    private String nullOutIfEmpty(String value) {
        if (StringUtils.isEmpty(value)) {
            value = null;
        }
        return value;
    }

}
