package com.atlassian.confluence.extra.flyingpdf.config;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;

public abstract class AbstractConfigurePdfExportAction extends ConfluenceActionSupport {
    protected BandanaContext context;
    protected PermissionManager permissionManager;
    protected PdfExportSettingsManager pdfSettings;

    public AbstractConfigurePdfExportAction() {
        context = new ConfluenceBandanaContext();
    }

    public void setPdfExportSettingsManager(PdfExportSettingsManager pdfSettings) {
        this.pdfSettings = pdfSettings;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Override
    public boolean isPermitted() {
        return permissionManager.isConfluenceAdministrator(getRemoteUser());
    }

    protected BandanaContext getBandanaContext() {
        return context;
    }
}
