package com.atlassian.confluence.extra.flyingpdf;

import com.atlassian.confluence.importexport.ImportExportException;
import org.w3c.dom.Document;

import java.io.File;

public interface XmlToPdfConverter {

    /**
     * Combine a list of files containing XHTML content into a single PDF document which is written to the file system.
     *
     * @param filenamePrefix the start part of the name of the PDF file which will be created param xhtml the Document
     *                       to be rendered to a PDF
     * @param xhtml          the body of the document that is going to be converted to PDF
     * @param contextPath    the context path
     * @return a File containing the output PDF document.
     * @throws ImportExportException on any exceptions during the conversion
     */
    File convertXhtmlToPdf(String filenamePrefix, Document xhtml, String contextPath) throws ImportExportException;

    /**
     * Combine a list of files containing XHTML content into a single PDF document which is written to the file system.
     *
     * @param filenamePrefix the start part of the name of the PDF file which will be created param xhtml the Document
     *                       to be rendered to a PDF
     * @param xhtml          the body of the document that is going to be converted to PDF
     * @param progress       the progress monitor to be informed during the operation
     * @param contextPath    the context path
     * @return a File containing the output PDF document.
     * @throws ImportExportException on any exceptions during the conversion
     */
    File convertXhtmlToPdf(String filenamePrefix, Document xhtml, PdfExportProgressMonitor progress, String contextPath)
            throws ImportExportException;
}