/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.impl;

import com.atlassian.confluence.extra.flyingpdf.html.DecorationPolicy;
import com.atlassian.confluence.extra.flyingpdf.impl.ContentTreeLongRunningTask;
import com.atlassian.confluence.extra.flyingpdf.impl.DiagnosticPdfExporterService;
import com.atlassian.confluence.extra.flyingpdf.impl.PdfExportLongRunningTask;
import com.atlassian.confluence.extra.flyingpdf.impl.PdfExportSemaphore;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.importexport.impl.ExportFileNameGenerator;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class PdfExportLongRunningTaskFactory {
    private final GateKeeper gateKeeper;
    private final SpaceManager spaceManager;
    private final PdfExportSemaphore pdfExportSemaphore;
    private final ImportExportManager importExportManager;
    private final TransactionTemplate transactionTemplate;
    private final ExportFileNameGenerator pdfExportFileNameGenerator;
    private final DiagnosticPdfExporterService flyingPdfExporterService;

    public PdfExportLongRunningTaskFactory(@ComponentImport GateKeeper gateKeeper, @ComponentImport SpaceManager spaceManager, @ComponentImport ImportExportManager importExportManager, @ComponentImport TransactionTemplate transactionTemplate, PdfExportSemaphore pdfExportSemaphore, ExportFileNameGenerator pdfExportFileNameGenerator, DiagnosticPdfExporterService flyingPdfExporterService) {
        this.gateKeeper = gateKeeper;
        this.spaceManager = spaceManager;
        this.pdfExportSemaphore = pdfExportSemaphore;
        this.importExportManager = importExportManager;
        this.transactionTemplate = transactionTemplate;
        this.pdfExportFileNameGenerator = pdfExportFileNameGenerator;
        this.flyingPdfExporterService = flyingPdfExporterService;
    }

    public PdfExportLongRunningTask createNewLongRunningTask(List<String> contentToBeExported, Space space, User remoteUser, String contextPath, DecorationPolicy decorations) {
        PdfExportLongRunningTask task = new PdfExportLongRunningTask(contentToBeExported, space, remoteUser, contextPath, this.pdfExportSemaphore, decorations);
        task.setImportExportManager(this.importExportManager);
        task.setSpaceManager(this.spaceManager);
        task.setFlyingPdfExporterService(this.flyingPdfExporterService);
        task.setTransactionTemplate(this.transactionTemplate);
        task.setGateKeeper(this.gateKeeper);
        return task;
    }

    public ContentTreeLongRunningTask createNewContentTreeLongRunningTask(I18NBean i18NBean, Space space, User remoteUser, String contextPath) {
        return new ContentTreeLongRunningTask(this.importExportManager, this.transactionTemplate, i18NBean, space, remoteUser, this.gateKeeper, contextPath, this.pdfExportFileNameGenerator, this.pdfExportSemaphore);
    }
}

