package com.atlassian.confluence.extra.flyingpdf.util;

import java.io.File;
import java.io.Serializable;
import java.util.Objects;

/**
 * PDF file with precomputed size
 */
public class RenderedPdfFile implements Serializable {

    private final File file;

    private final int numPages;

    public static RenderedPdfFile withKnownSize(File file, int numPages) {
        return new RenderedPdfFile(file, numPages);
    }

    private RenderedPdfFile(File file, Integer numPages) {
        this.file = file;
        this.numPages = numPages;
    }

    public File getFile() {
        return file;
    }

    public int getNumPages() {
        return numPages;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RenderedPdfFile that = (RenderedPdfFile) o;
        return Objects.equals(file, that.file) &&
                Objects.equals(numPages, that.numPages);
    }

    @Override
    public int hashCode() {
        return Objects.hash(file, numPages);
    }
}
