package com.atlassian.confluence.extra.flyingpdf.sandbox;

import com.atlassian.confluence.util.sandbox.SandboxSerializer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import static com.atlassian.confluence.util.sandbox.SandboxSerializers.compositeByteArraySerializer;
import static com.atlassian.confluence.util.sandbox.SandboxSerializers.intSerializer;
import static com.atlassian.confluence.util.sandbox.SandboxSerializers.stringSerializer;

public class SandboxPdfJoinResponse {

    private final File pdf;

    private final int numberOfPages;

    SandboxPdfJoinResponse(File pdf, int pdfPagesNum) {
        this.pdf = pdf;
        this.numberOfPages = pdfPagesNum;
    }

    public File getPdf() {
        return pdf;
    }

    public int getNumberOfPages() {
        return numberOfPages;
    }

    static Serializer serializer() {
        return Serializer.instance;
    }

    static final class Serializer implements SandboxSerializer<SandboxPdfJoinResponse> {
        static final Serializer instance = new SandboxPdfJoinResponse.Serializer();

        private Serializer() {
        }

        @Override
        public byte[] serialize(SandboxPdfJoinResponse conversionResponse) {
            List<byte[]> fields = new ArrayList<>();

            fields.add(stringSerializer().serialize(conversionResponse.getPdf().getAbsolutePath()));
            fields.add(intSerializer().serialize(conversionResponse.getNumberOfPages()));

            return compositeByteArraySerializer().serialize(fields);
        }

        @Override
        public SandboxPdfJoinResponse deserialize(byte[] bytes) {
            List<byte[]> fields = compositeByteArraySerializer().deserialize(bytes);
            return new SandboxPdfJoinResponse(
                    new File(stringSerializer().deserialize(fields.get(0))),
                    intSerializer().deserialize(fields.get(1))
            );
        }
    }
}
