package com.atlassian.confluence.extra.flyingpdf.sandbox;

import com.atlassian.confluence.importexport.resource.DownloadResourceManager;
import com.atlassian.confluence.util.sandbox.SandboxCallback;
import com.atlassian.confluence.util.sandbox.SandboxCallbackContext;
import com.atlassian.confluence.util.sandbox.SandboxSerializer;
import com.atlassian.confluence.util.sandbox.SandboxSerializers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Optional;

/**
 * Sandbox asks Confluence here whether given resource is related to Connie, or should be fetched via web.
 * Related to {@link GetResourceCallback}
 */
public class MatchResourceCallback implements SandboxCallback<String, Boolean> {
    private static final Logger log = LoggerFactory.getLogger(MatchResourceCallback.class);

    @Override
    public Boolean apply(SandboxCallbackContext context, String uri) {
        Optional<DownloadResourceManager> downloadResourceManager = context.get(DownloadResourceManager.class);

        if (!downloadResourceManager.isPresent()) {
            log.error("DownloadResourceManager is not registered in callback context");
            return false;
        }

        return downloadResourceManager.get().matches(uri);
    }

    @Override
    public SandboxSerializer<String> inputSerializer() {
        return SandboxSerializers.stringSerializer();
    }

    @Override
    public SandboxSerializer<Boolean> outputSerializer() {
        return new SandboxSerializer<Boolean>() {
            @Override
            public byte[] serialize(Boolean status) {
                return status ? new byte[]{1} : new byte[]{0};
            }

            @Override
            public Boolean deserialize(byte[] bytes) {
                return bytes[0] == 1 ? Boolean.TRUE : Boolean.FALSE;
            }
        };
    }
}
