package com.atlassian.confluence.extra.flyingpdf.sandbox;

import com.atlassian.confluence.util.sandbox.SandboxSerializer;

import java.util.ArrayList;
import java.util.List;

import static com.atlassian.confluence.util.sandbox.SandboxSerializers.compositeByteArraySerializer;

public class GetResourceCallbackResponse {
    private final byte[] data;

    public GetResourceCallbackResponse(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return data;
    }

    static Serializer serializer() {
        return Serializer.instance;
    }

    static class Serializer implements SandboxSerializer<GetResourceCallbackResponse> {
        static final Serializer instance = new Serializer();

        private Serializer() {
        }

        @Override
        public byte[] serialize(GetResourceCallbackResponse response) {
            List<byte[]> fields = new ArrayList<>();
            fields.add(response.getData());
            return compositeByteArraySerializer().serialize(fields);
        }

        @Override
        public GetResourceCallbackResponse deserialize(byte[] bytes) {
            List<byte[]> fields = compositeByteArraySerializer().deserialize(bytes);
            return new GetResourceCallbackResponse(fields.get(0));
        }
    }

}
