package com.atlassian.confluence.extra.flyingpdf.config;

import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEvent;

import java.io.Serializable;

/**
 * Remote event published when a custom PDF font is removed.
 */
public class CustomFontRemovedEvent extends ConfluenceEvent implements Serializable, ClusterEvent {
    private final String fontName;

    public CustomFontRemovedEvent(Object src, String fontName) {
        super(src);
        this.fontName = fontName;
    }

    public String getFontName() {
        return fontName;
    }
}