/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ext.DefaultHandler2;
import tdm.lib.Node;
import tdm.lib.XMLElementNode;
import tdm.lib.XMLNode;
import tdm.lib.XMLTextNode;

public class XMLPrinter
extends DefaultHandler2 {
    private static final int STATE_CHARS = 0;
    private static final int STATE_TAG = 1;
    private int state = -1;
    int indent = 0;
    private boolean prettyPrint = false;
    private static final String IND = "                                                                              ";
    private PrintWriter pw = null;
    Stack csstack = new Stack();
    Integer childcounter = null;
    final Integer HAS_CONTENT = new Integer(0);

    public XMLPrinter(Writer writer, boolean aPrettyPrint) {
        this.pw = new PrintWriter(writer);
        this.prettyPrint = aPrettyPrint;
    }

    public XMLPrinter(OutputStream out) {
        this(out, false);
    }

    public XMLPrinter(OutputStream out, boolean aPrettyPrint) {
        this(new OutputStreamWriter(out), aPrettyPrint);
    }

    @Override
    public void startDocument() {
        this.childcounter = this.HAS_CONTENT;
        this.state = 1;
    }

    @Override
    public void endDocument() {
        if (!this.prettyPrint) {
            this.pw.println();
        }
        this.pw.flush();
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (this.childcounter == null) {
            this.printWithNL(">", this.prettyPrint);
            this.childcounter = this.HAS_CONTENT;
        }
        StringBuffer tagopen = new StringBuffer();
        if (this.state == 1 && !this.prettyPrint) {
            tagopen.append("\n");
        }
        tagopen.append('<');
        tagopen.append(qName);
        if (atts != null && atts.getLength() != 0) {
            for (int i = 0; i < atts.getLength(); ++i) {
                tagopen.append(' ');
                tagopen.append(atts.getQName(i));
                tagopen.append('=');
                tagopen.append('\"');
                tagopen.append(XMLPrinter.toEntities(atts.getValue(i)));
                tagopen.append('\"');
            }
        }
        this.csstack.push(this.childcounter);
        this.childcounter = null;
        this.pw.print((this.prettyPrint ? IND.substring(0, this.indent) : "") + tagopen.toString());
        ++this.indent;
        this.state = 1;
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        --this.indent;
        if (this.childcounter == null) {
            this.printWithNL(" />", this.prettyPrint);
        } else {
            if (this.state == 1 && !this.prettyPrint) {
                this.pw.println();
            }
            this.printWithNL((this.prettyPrint ? IND.substring(0, this.indent) : "") + "</" + qName + ">", this.prettyPrint);
        }
        this.childcounter = (Integer)this.csstack.pop();
        this.state = 1;
    }

    protected void printWithNL(String s, boolean appendNL) {
        if (appendNL) {
            this.pw.println(s);
        } else {
            this.pw.print(s);
        }
    }

    @Override
    public void characters(char[] ch, int startpos, int length) {
        this.state = 0;
        if (this.childcounter != this.HAS_CONTENT) {
            this.printWithNL(">", this.prettyPrint);
        }
        this.childcounter = this.HAS_CONTENT;
        if (length == 0) {
            return;
        }
        String chars = XMLPrinter.toEntities(ch, startpos, length);
        this.printWithNL(chars, this.prettyPrint);
    }

    private static String toEntities(String str) {
        if (str.length() == 0) {
            return "";
        }
        char[] data = str.toCharArray();
        return XMLPrinter.toEntities(data, 0, data.length);
    }

    private static String toEntities(char[] data, int off, int len) {
        if (len == 0) {
            return "";
        }
        StringBuffer b = new StringBuffer();
        int end = off + len;
        int scan = off;
        block7: while (scan < end) {
            char c = data[scan++];
            switch (c) {
                case '&': {
                    b.append(data, off, scan - off - 1).append("&amp;");
                    break;
                }
                case '<': {
                    b.append(data, off, scan - off - 1).append("&lt;");
                    break;
                }
                case '>': {
                    b.append(data, off, scan - off - 1).append("&gt;");
                    break;
                }
                case '\'': {
                    b.append(data, off, scan - off - 1).append("&apos;");
                    break;
                }
                case '\"': {
                    b.append(data, off, scan - off - 1).append("&quot;");
                    break;
                }
                default: {
                    continue block7;
                }
            }
            off = scan;
        }
        if (off < scan) {
            b.append(data, off, scan - off);
        }
        return b.toString();
    }

    public void print(Node root) {
        this.print(root, false);
    }

    public void print(Node root, boolean fragment) {
        XMLNode c = root.getContent();
        if (!fragment) {
            this.startDocument();
        }
        if (c instanceof XMLTextNode) {
            char[] text = ((XMLTextNode)c).getText();
            this.characters(text, 0, text.length);
        } else {
            this.startElement("", "", ((XMLElementNode)c).getQName(), ((XMLElementNode)c).getAttributes());
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.print(root.getChildAsNode(i), true);
            }
            this.endElement("", "", ((XMLElementNode)c).getQName());
        }
        if (!fragment) {
            this.endDocument();
        }
    }
}

