/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Stack;
import javax.xml.stream.events.Attribute;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import tdm.lib.Node;
import tdm.lib.NodeFactory;
import tdm.lib.ParseException;
import tdm.lib.XMLElementNode;
import tdm.lib.XMLTextNode;

public class XMLParser
extends DefaultHandler {
    private static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    private XMLReader xr = null;
    private String currentText = null;
    private boolean currentTextIsCdata = false;
    private Node currentNode = null;
    private NodeFactory factory = null;
    private Stack treestack = new Stack();

    public XMLParser(NodeFactory nodefactory) {
        this.factory = nodefactory;
    }

    public XMLParser() throws Exception {
        this(DEFAULT_PARSER_NAME);
    }

    public XMLParser(String saxParserName) throws Exception {
        try {
            this.xr = XMLReaderFactory.createXMLReader(saxParserName);
        }
        catch (Exception e) {
            this.xr = XMLReaderFactory.createXMLReader();
        }
        this.xr.setContentHandler(this);
        this.xr.setErrorHandler(this);
        try {
            this.xr.setFeature("http://xml.org/sax/features/namespaces", false);
            this.xr.setFeature("http://xml.org/sax/features/validation", false);
            this.xr.setFeature("http://xml.org/sax/features/resolve-dtd-uris", false);
        }
        catch (SAXException e) {
            throw new Exception("Error setting features:" + e.getMessage());
        }
    }

    public void endElement() {
        if (this.currentText != null) {
            this.currentNode.addChild(this.factory.makeNode(new XMLTextNode(this.currentText, this.currentTextIsCdata)));
        }
        this.currentText = null;
        this.currentTextIsCdata = false;
        this.currentNode = (Node)this.treestack.pop();
    }

    public Node parse(String file, NodeFactory aFactory) throws ParseException, FileNotFoundException, IOException {
        return this.parse(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"), aFactory);
    }

    public Node parse(Reader file, NodeFactory aFactory) throws ParseException, IOException {
        this.factory = aFactory;
        try {
            InputSource is = new InputSource(file);
            this.xr.parse(is);
        }
        catch (SAXException x) {
            throw new ParseException(x.getMessage());
        }
        Node root = this.currentNode;
        this.currentNode = null;
        this.factory = null;
        return root;
    }

    protected Node getRoot() {
        return this.currentNode;
    }

    @Override
    public void startDocument() {
        this.currentNode = this.factory.makeNode(new XMLElementNode("$ROOT$", new AttributesImpl()));
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (this.currentText != null) {
            this.currentNode.addChild(this.factory.makeNode(new XMLTextNode(this.currentText.trim().toCharArray())));
        }
        this.currentText = null;
        this.currentTextIsCdata = false;
        Node n = this.factory.makeNode(new XMLElementNode(qName, atts));
        this.currentNode.addChild(n);
        this.treestack.push(this.currentNode);
        this.currentNode = n;
    }

    public void startElement(String uri, String name, String qName, List<Attribute> atts) {
        if (this.currentText != null) {
            this.currentNode.addChild(this.factory.makeNode(new XMLTextNode(this.currentText.toCharArray())));
        }
        this.currentText = null;
        this.currentTextIsCdata = false;
        Node n = this.factory.makeNode(new XMLElementNode(qName, atts));
        this.currentNode.addChild(n);
        this.treestack.push(this.currentNode);
        this.currentNode = n;
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        this.endElement();
    }

    public void characters(String chars, boolean cdata) {
        this.currentText = this.currentText == null ? chars : this.currentText + chars;
        this.currentTextIsCdata = cdata;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        boolean lastIsWS = this.currentText == null || this.currentText.endsWith(" ");
        boolean hasNonWs = false;
        StringBuffer sb = new StringBuffer();
        for (int i = start; i < start + length; ++i) {
            if (Character.isWhitespace(ch[i])) {
                if (lastIsWS) continue;
                sb.append(" ");
                lastIsWS = true;
                continue;
            }
            sb.append(ch[i]);
            lastIsWS = false;
            hasNonWs = true;
        }
        String chars = sb.toString();
        if (this.currentText != null) {
            this.currentText = this.currentText + chars;
        } else if (hasNonWs) {
            this.currentText = chars;
        }
    }
}

