/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import tdm.lib.BaseNode;
import tdm.lib.BranchNode;
import tdm.lib.Diff;
import tdm.lib.IdIndex;
import tdm.lib.Node;
import tdm.lib.ParseException;
import tdm.lib.XMLElementNode;
import tdm.lib.XMLNode;
import tdm.lib.XMLTextNode;

public class Patch {
    public static final Node DONT_EXPAND_COPY = new BaseNode(null);

    public void patch(Node base, BranchNode diff, ContentHandler ch) throws ParseException, SAXException {
        this.patch(base, diff, ch, new Diff.BFSIndex(base));
    }

    public void patch(Node base, BranchNode diff, ContentHandler ch, IdIndex index) throws ParseException, SAXException {
        BranchNode patched = this.patch(base, diff, index);
        ch.startDocument();
        this.dumpTree(patched.getChild(0), ch);
        ch.endDocument();
    }

    private void dumpTree(BranchNode n, ContentHandler ch) throws SAXException {
        if (n.getContent() instanceof XMLTextNode) {
            char[] text = ((XMLTextNode)n.getContent()).getText();
            ch.characters(text, 0, text.length);
        } else {
            XMLElementNode en = (XMLElementNode)n.getContent();
            ch.startElement("", "", en.getQName(), en.getAttributes());
            for (int i = 0; i < n.getChildCount(); ++i) {
                this.dumpTree(n.getChild(i), ch);
            }
            ch.endElement("", "", en.getQName());
        }
    }

    protected BranchNode patch(Node base, BranchNode diff, IdIndex index) throws ParseException {
        BranchNode patch = new BranchNode(new XMLElementNode("$DUMMY$", new AttributesImpl()));
        XMLNode dc = (diff = diff.getChild(0)).getContent();
        if (!(dc instanceof XMLElementNode) || !"diff".equals(((XMLElementNode)dc).getQName())) {
            throw new ParseException("Invalid root tag for diff");
        }
        String op = ((XMLElementNode)dc).getAttributes().getValue("op");
        if (op == null || op.length() == 0) {
            this.copy(patch, diff, base, index.getRootId(), index);
        } else if ("insert".equals(op)) {
            this.insert(patch, diff, index);
        } else {
            throw new ParseException("Invalid rootop for diff: " + op);
        }
        return patch.getChild(0);
    }

    protected void insert(BranchNode patch, BranchNode diff, IdIndex index) throws ParseException {
        XMLNode cmdcontent = diff.getContent();
        if (cmdcontent instanceof XMLTextNode || !Diff.DEFAULT_CONFIG.RESERVED.contains(((XMLElementNode)cmdcontent).getQName())) {
            BranchNode node = new BranchNode(cmdcontent);
            patch.addChild(node);
            for (int i = 0; i < diff.getChildCount(); ++i) {
                this.insert(node, diff.getChild(i), index);
            }
        } else {
            XMLElementNode ce = (XMLElementNode)cmdcontent;
            if (ce.getQName().equals(Diff.DIFF_ESC_TAG) || ce.getQName().equals(Diff.DIFF_INS_TAG)) {
                for (int i = 0; i < diff.getChildCount(); ++i) {
                    this.insert(patch, diff.getChild(i), index);
                }
            } else {
                Node srcRoot = null;
                String src = null;
                try {
                    src = ce.getAttributes().getValue("src");
                    srcRoot = index.lookup(src);
                }
                catch (Exception e) {
                    throw new ParseException("DIFFSYNTAX: Invalid parameters in command " + ce.toString());
                }
                this.copy(patch, diff, srcRoot, src, index);
            }
        }
    }

    protected void copy(BranchNode patch, BranchNode diff, Node srcRoot, Object src, IdIndex index) throws ParseException {
        Vector<Node> dstNodes = new Vector<Node>();
        HashMap stopNodes = new HashMap();
        long nsrc = -1L;
        long run = 1L;
        try {
            String runS = ((XMLElementNode)diff.getContent()).getAttributes().getValue("run");
            if (runS != null) {
                run = Long.parseLong(runS);
            }
            if (run > 1L) {
                nsrc = Long.parseLong(src.toString());
            }
        }
        catch (Exception e) {
            throw new ParseException("DIFFSYNTAX: Invalid run count/non-number src for copy tag " + diff.toString());
        }
        for (int i = 0; i < diff.getChildCount(); ++i) {
            XMLNode content = diff.getChild(i).getContent();
            Node stopNode = null;
            if (content instanceof XMLTextNode || !((XMLElementNode)content).getQName().equals(Diff.DIFF_COPY_TAG) && !((XMLElementNode)content).getQName().equals(Diff.DIFF_INS_TAG)) {
                throw new ParseException("DIFFSYNTAX: Only copy or insert commands may appear below a copy command");
            }
            XMLElementNode stopCommand = (XMLElementNode)content;
            try {
                stopNode = index.lookup(stopCommand.getAttributes().getValue("dst"));
            }
            catch (Exception e) {
                throw new ParseException("DIFFSYNTAX: Invalid parameters in command " + stopNode.toString());
            }
            dstNodes.add(stopNode);
            if (stopNodes.containsKey(stopNode)) continue;
            stopNodes.put(stopNode, null);
        }
        for (long iRun = 1L; iRun < run; ++iRun) {
            this.dfsCopy(patch, srcRoot, null, src);
            src = String.valueOf(nsrc + iRun);
            srcRoot = index.lookup(src);
        }
        this.dfsCopy(patch, srcRoot, stopNodes, src);
        for (int i = 0; i < diff.getChildCount(); ++i) {
            this.insert((BranchNode)stopNodes.get(dstNodes.elementAt(i)), diff.getChild(i), index);
        }
    }

    protected void dfsCopy(BranchNode dst, Node src, Map stopNodes, Object srcId) {
        if (src == DONT_EXPAND_COPY) {
            if (stopNodes != null && stopNodes.size() > 0) {
                throw new IllegalStateException("Can't use noexpand with truncated subtrees");
            }
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "", "src", "CDATA", srcId.toString());
            BranchNode node = new BranchNode(new XMLElementNode(Diff.DIFF_COPY_TAG, atts));
            dst.addChild(node);
        } else {
            this.dfsCopyTree(dst, src, stopNodes);
        }
    }

    protected void dfsCopyTree(BranchNode dst, Node src, Map stopNodes) {
        BranchNode copied = new BranchNode(src.getContent());
        dst.addChild(copied);
        if (stopNodes != null && stopNodes.containsKey(src)) {
            stopNodes.put(src, copied);
            return;
        }
        for (int i = 0; i < src.getChildCount(); ++i) {
            this.dfsCopyTree(copied, src.getChildAsNode(i), stopNodes);
        }
    }
}

