/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import tdm.lib.BaseNode;
import tdm.lib.BranchNode;
import tdm.lib.Node;
import tdm.lib.XMLElementNode;
import tdm.lib.XMLNode;
import tdm.lib.XMLTextNode;

public class Measure {
    public static final double MAX_DIST = 1.0;
    public static final double ZERO_CHILDREN_MATCH = 1.0;
    public static final int ELEMENT_NAME_INFO = 1;
    public static final int ATTR_INFO = 2;
    public static final int ATTR_VALUE_THRESHOLD = 5;
    public static final int TEXT_THRESHOLD = 5;
    private int mismatched = 0;
    private int total = 0;
    private boolean totalMismatch = false;
    private static final int C = 20;
    private static final int INIT_CAPACITY = 2048;
    private static int Q = 4;
    private Map aGrams = new HashMap(2048);
    private Map bGrams = new HashMap(2048);

    public static void main(String[] args) {
        String a = "return stringDist( a, b, a.length()+b.length() );";
        String b = "return stzingDist( a, b, a.length()+b.length() );";
        System.out.println("a=" + a);
        System.out.println("b=" + b);
        System.out.println("Dist = " + new Measure().qDist(a, b));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDistance(Node a, Node b) {
        try {
            if (a != null && b != null) {
                this.includeNodes(a, b);
            }
            double penalty = Math.max(0.0, 1.0 - (double)this.total / 20.0);
            double distance = penalty + (1.0 - penalty) * (double)this.mismatched / (double)this.total;
            double d = this.totalMismatch ? 1.0 : distance;
            return d;
        }
        finally {
            this.resetDistance();
        }
    }

    private double getDistance() {
        return this.getDistance(null, null);
    }

    private void resetDistance() {
        this.mismatched = 0;
        this.total = 0;
        this.totalMismatch = false;
    }

    private void includeNodes(Node a, Node b) {
        if (a == null || b == null || this.totalMismatch) {
            return;
        }
        XMLNode ca = a.getContent();
        XMLNode cb = b.getContent();
        if (ca instanceof XMLElementNode && cb instanceof XMLElementNode) {
            int i;
            XMLElementNode ea = (XMLElementNode)ca;
            XMLElementNode eb = (XMLElementNode)cb;
            ++this.total;
            this.mismatched += ea.getQName().equals(eb.getQName()) ? 0 : 1;
            Attributes aa = ea.getAttributes();
            Attributes ab = eb.getAttributes();
            for (i = 0; i < aa.getLength(); ++i) {
                int index = ab.getIndex(aa.getQName(i));
                if (index != -1) {
                    String v1 = aa.getValue(i);
                    String v2 = ab.getValue(index);
                    int amismatch = this.stringDist(v1, v2, 1.0);
                    int info = (v1.length() > 5 ? v1.length() : 1) + (v2.length() > 5 ? v2.length() : 1);
                    this.mismatched += amismatch > info ? info : amismatch;
                    this.total += info;
                    continue;
                }
                this.mismatched += 2;
                this.total += 2;
            }
            for (i = 0; i < ab.getLength(); ++i) {
                if (aa.getIndex(ab.getQName(i)) != -1) continue;
                this.mismatched += 2;
                this.total += 2;
            }
        } else if (ca instanceof XMLTextNode && cb instanceof XMLTextNode) {
            int info = ca.getInfoSize() + cb.getInfoSize() / 2;
            int amismatch = this.stringDist(((XMLTextNode)ca).getText(), ((XMLTextNode)cb).getText(), 1.0) / 2;
            this.mismatched += amismatch > info ? info : amismatch;
            this.total += info;
        } else {
            this.totalMismatch = true;
        }
    }

    public int stringDist(String a, String b, double limit) {
        return this.qDist(a, b);
    }

    public int stringDist(char[] a, char[] b, double limit) {
        return this.qDist(a, b);
    }

    public double childListDistance(Node a, Node b) {
        int i;
        if (a.getChildCount() == 0 && b.getChildCount() == 0) {
            return 1.0;
        }
        char[] ac = new char[a.getChildCount()];
        char[] bc = new char[b.getChildCount()];
        for (i = 0; i < a.getChildCount(); ++i) {
            ac[i] = (char)(a.getChildAsNode(i).getContent().getContentHash() & 0xFFFF);
        }
        for (i = 0; i < b.getChildCount(); ++i) {
            bc[i] = (char)(b.getChildAsNode(i).getContent().getContentHash() & 0xFFFF);
        }
        return (double)this.stringDist(ac, bc, 1.0) / ((double)a.getChildCount() + (double)b.getChildCount());
    }

    public int matchedChildListDistance(BaseNode a, BranchNode b) {
        int i;
        char[] ac = new char[a.getChildCount()];
        char[] bc = new char[b.getChildCount()];
        for (i = 0; i < a.getChildCount(); ++i) {
            ac[i] = (char)(i + 1);
        }
        for (i = 0; i < b.getChildCount(); ++i) {
            BaseNode m = b.getBaseMatch();
            bc[i] = m != null && m.getParent() == a ? (char)m.getChildPos() : (char)(-(i + 1));
        }
        return this.stringDist(ac, bc, 1.0);
    }

    protected int qDist(String a, String b) {
        this.decideQ(a.length() + b.length());
        this.buildQGrams(a, this.aGrams);
        this.buildQGrams(b, this.bGrams);
        return this.calcQDistance();
    }

    protected int qDist(char[] a, char[] b) {
        this.decideQ(a.length + b.length);
        this.buildQGrams(a, this.aGrams);
        this.buildQGrams(b, this.bGrams);
        return this.calcQDistance();
    }

    protected void buildQGrams(String a, Map grams) {
        grams.clear();
        for (int i = 0; i < a.length(); ++i) {
            String gram = a.substring(i, i + Q > a.length() ? a.length() : i + Q);
            if (grams.containsKey(gram)) {
                ++((Counter)grams.get((Object)gram)).count;
                continue;
            }
            grams.put(gram, new Counter());
        }
    }

    protected void buildQGrams(char[] a, Map grams) {
        grams.clear();
        for (int i = 0; i < a.length; ++i) {
            int count = i + Q > a.length ? a.length - i : Q;
            String gram = new String(a, i, count);
            if (grams.containsKey(gram)) {
                ++((Counter)grams.get((Object)gram)).count;
                continue;
            }
            grams.put(gram, new Counter());
        }
    }

    protected int decideQ(int total) {
        int q = 1;
        if (total > 150) {
            q = 4;
        } else if (total > 50) {
            q = 2;
        }
        return q;
    }

    protected int calcQDistance() {
        int dist = 0;
        for (Object gramA : this.aGrams.keySet()) {
            int countA = ((Counter)this.aGrams.get(gramA)).count;
            int countB = 0;
            if (this.bGrams.containsKey(gramA)) {
                countB = ((Counter)this.bGrams.get(gramA)).count;
                continue;
            }
            dist += Math.abs(countA - countB);
        }
        for (Object gramB : this.bGrams.keySet()) {
            if (this.aGrams.containsKey(gramB)) continue;
            dist += ((Counter)this.bGrams.get(gramB)).count;
        }
        return dist;
    }

    class Counter {
        public int count = 1;

        Counter() {
        }
    }
}

