/*
 * Decompiled with CFR 0.152.
 */
package tdm.editgen;

import java.util.HashMap;
import java.util.Map;
import tdm.lib.BaseNode;
import tdm.lib.XMLNode;

public class MarkableBaseNode
extends BaseNode {
    protected static Map markLog = null;
    public static final int MARK_NONE = 0;
    public static final int MARK_CONTENT = 1;
    public static final int MARK_STRUCTURE = 2;
    protected int markCount = 0;
    protected int subtreeSize = 0;

    MarkableBaseNode(XMLNode aContent) {
        super(aContent);
    }

    public void beginMarkTransaction() {
        if (markLog != null) {
            throw new IllegalStateException("Recursive transactions not supported");
        }
        markLog = new HashMap();
    }

    public void commitMarkTransaction() {
        if (markLog == null) {
            throw new IllegalStateException("No transaction in progress");
        }
        markLog = null;
    }

    public void abortMarkTransaction() {
        if (markLog == null) {
            throw new IllegalStateException("No transaction in progress");
        }
        for (Map.Entry e : markLog.entrySet()) {
            ((MarkableBaseNode)e.getKey()).markCount = (Integer)e.getValue();
        }
        markLog = null;
    }

    public void mark(int mark) {
        if (markLog != null) {
            markLog.put(this, new Integer(this.markCount));
        }
        this.markCount |= mark;
    }

    public boolean isMarked() {
        return this.markCount > 0;
    }

    public boolean isMarkedContent() {
        return (this.markCount & 1) != 0;
    }

    public boolean isMarkedStructure() {
        return (this.markCount & 2) != 0;
    }

    public int getMark() {
        return this.markCount;
    }

    public void lock(int type) {
        this.lock(true, true, type);
    }

    public void lockSubtree(int type) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            MarkableBaseNode n = (MarkableBaseNode)this.getChild(i);
            n.lock(type);
            n.lockSubtree(type);
        }
    }

    public void lockLeft(int type) {
        this.lock(true, false, type);
    }

    public void lockRight(int type) {
        this.lock(false, true, type);
    }

    public void lock(boolean left, boolean right, int type) {
        MarkableBaseNode leftSib = left ? (MarkableBaseNode)this.getLeftSibling() : null;
        MarkableBaseNode rightSib = right ? (MarkableBaseNode)this.getRightSibling() : null;
        this.mark(type);
        if (rightSib != null) {
            rightSib.mark(type);
        }
        if (leftSib != null) {
            leftSib.mark(type);
        }
    }

    public int getSubteeSize() {
        return this.subtreeSize;
    }

    public void setSubtreeSize(int aSize) {
        this.subtreeSize = aSize;
    }
}

