/**
 * @module confluence/reload-captcha
 */
define('confluence/reload-captcha', [
    'jquery',
    'ajs',
    'confluence/captcha-handler',
    'wrm/context-path'
], function(
    $,
    AJS,
    captchaHandler,
    contextPath
) {
    'use strict';

    return function() {
        var reloadCaptcha = function() {
            var captchaId = Math.random();
            var loginCaptchaImg;

            $('input[name="captchaId"]').val(captchaId);
            loginCaptchaImg = document.querySelector('#login-captcha-img');

            if (loginCaptchaImg) {
                captchaHandler.bindingEvent(loginCaptchaImg);
                loginCaptchaImg.setAttribute('src', contextPath() + '/jcaptcha?id=' + captchaId + '&action=login');
                $('#captcha-response').focus();
            } else {
                $('.captcha-image').attr('src', contextPath() + '/jcaptcha?id=' + captchaId);
            }
        };

        $('#captcha-container .reload').click(function(e) {
            reloadCaptcha();
            $('#captcha-response').focus();
            e.stopPropagation();
            return false;
        });
    };
});

/* istanbul ignore next */
require('confluence/module-exporter').safeRequire('confluence/reload-captcha', function(ReloadCaptcha) {
    'use strict';

    require('ajs').toInit(ReloadCaptcha);
});
