/**
 * @module confluence/login
 */
define('confluence/login', [
    'jquery',
    'ajs',
    'document',
    'confluence/captcha-handler',
    'wrm/context-path'
], function(
    $,
    AJS,
    document,
    captchaHandler,
    contextPath
) {
    'use strict';

    return function() {
        var $loginButton;
        var $loginForm;
        var $usernameErrorMessage;
        var $passwordErrorMessage;
        var $username;
        var $password;

        function showSignup() {
            var $signupSection = $('.signup-section');

            if ($signupSection.length !== 0) {
                $('.login-section').hide();
                $signupSection.show();
            }
        }

        function showLogin() {
            $('.login-section').show();
            $('.signup-section').hide();
        }

        if (document.URL.indexOf('login.action') > -1 || document.URL.indexOf('logout.action') > -1) {
            showLogin();
        }

        if (document.URL.indexOf('signup.action') > -1) {
            showSignup();
        }

        $('#signupMessage').delegate('click', 'a', function(e) {
            e.preventDefault();
            showSignup();
        });

        $('#loginMessage').delegate('click', 'a', function(e) {
            e.preventDefault();
            showLogin();
        });

        var errorTemplate = '<div id="os_{field}_error" class="error" style="display:none"><span class="error">{message}</span></div>';

        $usernameErrorMessage = $(AJS.template(errorTemplate).fill({ field: 'username', message: AJS.I18n.getText('login.username.required') }).toString());
        $passwordErrorMessage = $(AJS.template(errorTemplate).fill({ field: 'password', message: AJS.I18n.getText('login.password.required') }).toString());

        $username = $('#os_username');
        $password = $('#os_password');

        var fetchCaptchaAndShow = function() {
            /* Only set captcha src for login flow in this js file. Return for all other flows.
              Since signup page comes with captcha (generated from backend), this function was resetting captchaId,
              leading to mismatch in captchaId during validation , hence we need to skip captchaId regeneration for signup)
            */
            if (document.URL.indexOf('login.action') === -1) {
                return;
            }

            var captchaId = Math.random();
            var captchaImg = document.querySelector('#login-captcha-img');

            $('input[name="captchaId"]').val(captchaId);

            if (captchaImg) {
                captchaHandler.bindingEvent(captchaImg);
                captchaImg.setAttribute('src', contextPath() + '/jcaptcha?id=' + captchaId + '&action=login');
            }
        };

        $(document).ready(function() {
            fetchCaptchaAndShow();
        });

        function validate() {
            var inputIsValid = true;

            if ($username.val().length < 1) {
                inputIsValid = false;
                $username.after($usernameErrorMessage.show());
            } else {
                $usernameErrorMessage.hide();
            }

            if ($password.val().length < 1) {
                inputIsValid = false;
                $password.after($passwordErrorMessage.show());
            } else {
                $passwordErrorMessage.hide();
            }

            return inputIsValid;
        }

        $loginButton = $('#loginButton');
        $loginForm = $loginButton.closest('form');
        $loginForm.submit(function(e) {
            var formIsValid;
            $loginButton.attr('enabled', 'false');
            formIsValid = validate();
            if (!formIsValid) {
                $loginButton.attr('enabled', 'true');
            }
            formIsValid || e.preventDefault();
        });
    };
});

/* istanbul ignore next */
require('confluence/module-exporter').safeRequire('confluence/login', function(Login) {
    'use strict';

    require('ajs').toInit(Login);
});
