(function($) {

/**
 * Where extensions to AUI that aren't ready to migrate should be stored.
 *
 * Functions added here should have a @since version and go on the roadmap to
 * be moved over after a suitable delay.
 */

/**
 * AJS.Data will be the namespace for accessing dynamic data passed from the
 * server to JavaScript via the page HTML.
 *
 * @since 3.4
 */
AJS.Data = $.extend({}, AJS.Data, {

    /**
     * Returns a value given the key.
     *
     * @method get
     * @param key
     * @return {String}
     */
    get: function (key) {
        return $("meta[name=ajs-" + key + "]").attr("content");
    }

});

})(AJS.$);

