/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import bucket.core.persistence.hibernate.schema.SchemaHelper;
import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.ConfigurationException;
import com.atlassian.confluence.upgrade.BuildNumComparator;
import com.atlassian.confluence.upgrade.BuildNumberUpgradeConstraint;
import com.atlassian.confluence.upgrade.DatabaseUpgradeTask;
import com.atlassian.confluence.upgrade.DeferredUpgradeTask;
import com.atlassian.confluence.upgrade.UpgradeError;
import com.atlassian.confluence.upgrade.UpgradeException;
import com.atlassian.confluence.upgrade.UpgradeManager;
import com.atlassian.confluence.upgrade.UpgradeTask;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUpgradeManager
implements UpgradeManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractUpgradeManager.class);
    private ApplicationConfiguration applicationConfig;
    private SchemaHelper schemaHelper;
    private List<UpgradeTask> upgradeTasks = Collections.emptyList();
    private List<UpgradeTask> preSchemaUpgradeTasks = Collections.emptyList();
    private List<UpgradeTask> schemaUpgradeTasks = Collections.emptyList();
    private List<DeferredUpgradeTask> pluginDependentUpgradeTasks = Collections.emptyList();
    private final List<UpgradeError> errors = new ArrayList<UpgradeError>();
    private AtomicBoolean upgraded = new AtomicBoolean(true);
    protected final Comparator<String> buildNumberComp = new BuildNumComparator();

    public void setApplicationConfig(ApplicationConfiguration applicationConfig) {
        this.applicationConfig = applicationConfig;
    }

    public void setSchemaHelper(SchemaHelper schemaHelper) {
        this.schemaHelper = schemaHelper;
    }

    @Override
    public void upgrade(JohnsonEventContainer agentJohnson) throws UpgradeException {
        List<UpgradeError> upgradePreReqErrors = this.runUpgradePrerequisites();
        if (upgradePreReqErrors.size() > 0) {
            this.upgraded.set(false);
            this.errors.addAll(upgradePreReqErrors);
            this.addJohnsonEvent(agentJohnson);
            return;
        }
        boolean needUpgrade = this.needUpgrade();
        boolean needSchemaUpgrade = Boolean.getBoolean("atlassian.forceSchemaUpdate") || needUpgrade;
        try {
            if (needSchemaUpgrade) {
                this.validateSchemaUpgradeTasks(this.getPreSchemaUpgradeTasks());
                this.schemaHelper.validateSchemaUpdateIfNeeded();
                this.validateSchemaUpgradeTasks(this.getSchemaUpgradeTasks());
            }
            if (needUpgrade) {
                this.validateUpgradeTasks(this.getAllUpgradeTasks());
            }
        }
        catch (UpgradeException e) {
            this.upgraded.set(false);
            this.addJohnsonValidationEvent(agentJohnson);
            throw e;
        }
        catch (ConfigurationException e) {
            this.upgraded.set(false);
            this.errors.add(new UpgradeError(e));
            this.addJohnsonValidationEvent(agentJohnson);
            throw new UpgradeException(e);
        }
        try {
            if (needSchemaUpgrade) {
                this.runSchemaUpgradeTasks(this.getPreSchemaUpgradeTasks());
                this.schemaHelper.updateSchemaIfNeeded();
                this.runSchemaUpgradeTasks(this.getSchemaUpgradeTasks());
            }
            if (needUpgrade) {
                this.runUpgradeTasks(this.getAllUpgradeTasks());
            }
            this.upgraded.set(true);
        }
        catch (UpgradeException e) {
            this.upgraded.set(false);
            this.addJohnsonEvent(agentJohnson);
            throw e;
        }
        catch (ConfigurationException e) {
            this.upgraded.set(false);
            this.errors.add(new UpgradeError(e));
            this.addJohnsonEvent(agentJohnson);
            throw new UpgradeException(e);
        }
    }

    private void validateSchemaUpgradeTasks(List<UpgradeTask> upgradeTasks) throws UpgradeException {
        this.executeUpgradeStep(upgradeTasks, UpgradeStep.SCHEMA_VALIDATION);
    }

    private void runSchemaUpgradeTasks(List<UpgradeTask> upgradeTasks) throws UpgradeException {
        this.executeUpgradeStep(upgradeTasks, UpgradeStep.SCHEMA_UPGRADE);
    }

    private void validateUpgradeTasks(List<UpgradeTask> upgradeTasks) throws UpgradeException {
        this.executeUpgradeStep(upgradeTasks, UpgradeStep.VALIDATION);
    }

    private void runUpgradeTasks(List<UpgradeTask> upgradeTasks) throws UpgradeException {
        this.upgradeStarted();
        this.executeUpgradeStep(upgradeTasks, UpgradeStep.UPGRADE);
        try {
            this.initialUpgradeFinished();
        }
        catch (Exception e) {
            this.errors.add(new UpgradeError(e));
            throw new UpgradeException(e);
        }
    }

    private void executeUpgradeStep(List<UpgradeTask> upgradeTasks, UpgradeStep step) throws UpgradeException {
        int localConfigurationBuildNumber = Integer.valueOf(this.getConfiguredBuildNumber());
        int databaseBuildNumber = Integer.valueOf(this.getDatabaseBuildNumber());
        for (UpgradeTask upgradeTask : upgradeTasks) {
            BuildNumberUpgradeConstraint constraint = upgradeTask.getConstraint();
            if (!constraint.test(localConfigurationBuildNumber)) continue;
            try {
                if (upgradeTask instanceof DatabaseUpgradeTask) {
                    if (constraint.test(databaseBuildNumber) && this.permitDatabaseUpgrades()) {
                        step.execute(this, upgradeTask);
                        if (step.shouldUpdateBuildNumber() && CollectionUtils.isEmpty(upgradeTask.getErrors())) {
                            this.setDatabaseBuildNumber(upgradeTask.getBuildNumber());
                        }
                    }
                } else {
                    step.execute(this, upgradeTask);
                }
                if (!CollectionUtils.isEmpty(upgradeTask.getErrors())) {
                    throw new UpgradeException("Upgrade task " + upgradeTask + " failed during the " + this + " phase");
                }
                if (!step.shouldUpdateBuildNumber()) continue;
                this.upgradeTaskSucceeded(upgradeTask);
            }
            catch (UpgradeException e) {
                throw e;
            }
            catch (Throwable e) {
                this.errors.add(new UpgradeError(e));
                throw new UpgradeException("Upgrade task " + upgradeTask + " failed during the " + (Object)((Object)step) + " phase " + "due to: " + e.getMessage(), e);
            }
            finally {
                if (!CollectionUtils.isEmpty(upgradeTask.getErrors())) {
                    this.errors.addAll(upgradeTask.getErrors());
                }
                step.postUpgrade(this, upgradeTask);
            }
        }
    }

    protected List<UpgradeTask> getAllUpgradeTasks() {
        ArrayList<UpgradeTask> upgradeTasks = new ArrayList<UpgradeTask>();
        upgradeTasks.addAll(this.getUpgradeTasks());
        upgradeTasks.addAll(this.getPluginDependentUpgradeTasks());
        Collections.sort(upgradeTasks, new Comparator<UpgradeTask>(){

            @Override
            public int compare(UpgradeTask o1, UpgradeTask o2) {
                Integer buildNumber1 = Integer.parseInt(o1.getBuildNumber());
                Integer buildNumber2 = Integer.parseInt(o2.getBuildNumber());
                return buildNumber1.compareTo(buildNumber2);
            }
        });
        return upgradeTasks;
    }

    protected void upgradeTaskSucceeded(UpgradeTask upgradeTask) throws Exception {
        this.setConfiguredBuildNumber(upgradeTask.getBuildNumber());
    }

    private void addJohnsonValidationEvent(JohnsonEventContainer johnson) {
        this.addJohnsonEvent(johnson, "Pre upgrade validation failed. Please consult the system logs for details. You will need to fix these problems and restart.");
    }

    private void addJohnsonEvent(JohnsonEventContainer johnson) {
        this.addJohnsonEvent(johnson, "Upgrade failed. Please consult the system logs for details. You will need to fix these problems, restore your database and confluence home directory to the pre upgrade state. Then retry the upgrade.");
    }

    private void addJohnsonEvent(JohnsonEventContainer johnson, String message) {
        if (johnson != null) {
            johnson.addEvent(new Event(EventType.get((String)"upgrade"), message, EventLevel.get((String)"error")));
        }
    }

    protected void upgradeStarted() {
        log.info("Starting automatic upgrade of Confluence");
    }

    public List<UpgradeTask> getPreSchemaUpgradeTasks() {
        return this.preSchemaUpgradeTasks;
    }

    public void setPreSchemaUpgradeTasks(List<UpgradeTask> preSchemaUpgradeTasks) {
        this.preSchemaUpgradeTasks = preSchemaUpgradeTasks;
    }

    public void setUpgradeTasks(List<UpgradeTask> upgradeTasks) {
        this.assertNoDuplicateBuildNumbers(upgradeTasks);
        this.upgradeTasks = upgradeTasks;
    }

    private void assertNoDuplicateBuildNumbers(List<UpgradeTask> upgradeTasks) throws IllegalStateException {
        HashSet buildNumbers = Sets.newHashSet();
        for (UpgradeTask upgradeTask : upgradeTasks) {
            if (buildNumbers.contains(upgradeTask.getBuildNumber())) {
                throw new IllegalStateException("Duplicate build number for upgrade task: " + upgradeTask.getClass().getName() + ", " + "build number: " + upgradeTask.getBuildNumber());
            }
            buildNumbers.add(upgradeTask.getBuildNumber());
        }
    }

    public List<UpgradeTask> getUpgradeTasks() {
        return this.upgradeTasks;
    }

    public void setSchemaUpgradeTasks(List<UpgradeTask> upgradeTasks) {
        this.schemaUpgradeTasks = upgradeTasks;
    }

    public List<UpgradeTask> getSchemaUpgradeTasks() {
        return this.schemaUpgradeTasks;
    }

    @Override
    public List<UpgradeError> getErrors() {
        return this.errors;
    }

    public void setPluginDependentUpgradeTasks(List<DeferredUpgradeTask> upgradeTasks) {
        this.pluginDependentUpgradeTasks = upgradeTasks;
    }

    public List<DeferredUpgradeTask> getPluginDependentUpgradeTasks() {
        return this.pluginDependentUpgradeTasks;
    }

    protected abstract List<UpgradeError> runUpgradePrerequisites();

    protected String getConfiguredBuildNumber() {
        return this.applicationConfig.getBuildNumber();
    }

    protected void setConfiguredBuildNumber(String buildNumber) throws ConfigurationException {
        if (!this.configuredBuildNumberNewerThan(buildNumber)) {
            this.applicationConfig.setBuildNumber(buildNumber);
            this.applicationConfig.save();
        }
    }

    @Override
    public boolean needUpgrade() {
        if (!this.applicationConfig.isSetupComplete()) {
            return false;
        }
        try {
            int realBuildNumber = Integer.parseInt(this.getRealBuildNumber());
            int configuredBuildNumber = Integer.parseInt(this.getConfiguredBuildNumber());
            return realBuildNumber != configuredBuildNumber;
        }
        catch (NumberFormatException e) {
            log.warn("Skipping upgrade because build numbers cannot be compared (application: \"{}\", configuration: \"{}\")", (Object)this.getRealBuildNumber(), (Object)this.getConfiguredBuildNumber());
            return false;
        }
    }

    @Override
    public boolean configuredBuildNumberNewerThan(String buildNumber) {
        return this.buildNumberComp.compare(this.getConfiguredBuildNumber(), buildNumber) > 0;
    }

    @Override
    public boolean taskNewerThan(String buildNumber, UpgradeTask upgradeTask) {
        return this.buildNumberComp.compare(upgradeTask.getBuildNumber(), buildNumber) > 0;
    }

    protected void initialUpgradeFinished() throws Exception {
        if (this.errors.isEmpty()) {
            if (this.permitDatabaseUpgrades()) {
                this.setDatabaseBuildNumber(this.getRealBuildNumber());
            }
            this.setConfiguredBuildNumber(this.getRealBuildNumber());
        }
        log.info("Upgrade initial stage completed successfully");
    }

    @Override
    public void entireUpgradeFinished() {
        log.info("Upgrade completed successfully");
    }

    protected abstract String getRealBuildNumber();

    protected abstract String getDatabaseBuildNumber();

    protected abstract void setDatabaseBuildNumber(String var1) throws Exception;

    protected boolean permitDatabaseUpgrades() throws UpgradeException {
        return true;
    }

    protected void postUpgrade() {
    }

    @Override
    public boolean isUpgraded() {
        return this.upgraded.get();
    }

    private static enum UpgradeStep {
        SCHEMA_VALIDATION{

            @Override
            public void execute(AbstractUpgradeManager upgradeManager, UpgradeTask upgradeTask) throws Exception {
                upgradeTask.validate();
            }
        }
        ,
        VALIDATION{

            @Override
            public void execute(AbstractUpgradeManager upgradeManager, UpgradeTask upgradeTask) throws Exception {
                upgradeTask.validate();
            }
        }
        ,
        SCHEMA_UPGRADE{

            @Override
            public void execute(AbstractUpgradeManager upgradeManager, UpgradeTask upgradeTask) throws Exception {
                upgradeTask.doUpgrade();
            }

            @Override
            public void postUpgrade(AbstractUpgradeManager upgradeManager, UpgradeTask upgradeTask) {
                upgradeManager.postUpgrade();
            }
        }
        ,
        UPGRADE{

            @Override
            public void execute(AbstractUpgradeManager upgradeManager, UpgradeTask upgradeTask) throws Exception {
                upgradeTask.doUpgrade();
            }

            @Override
            public boolean shouldUpdateBuildNumber() {
                return true;
            }

            @Override
            public void postUpgrade(AbstractUpgradeManager upgradeManager, UpgradeTask upgradeTask) {
                upgradeManager.postUpgrade();
            }
        };


        public abstract void execute(AbstractUpgradeManager var1, UpgradeTask var2) throws Exception;

        public boolean shouldUpdateBuildNumber() {
            return false;
        }

        public void postUpgrade(AbstractUpgradeManager upgradeManager, UpgradeTask upgradeTask) {
        }
    }
}

