/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.upgrade.UpgradeError;
import com.atlassian.confluence.upgrade.UpgradeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUpgradeTask
implements UpgradeTask {
    private List<UpgradeError> errors = new ArrayList<UpgradeError>();
    private String buildNumber;

    @Override
    public String getShortDescription() {
        return "Upgrade to build number: " + this.getBuildNumber();
    }

    protected void addError(UpgradeError error) {
        this.errors.add(error);
    }

    public void addErrors(String prefix, Collection<String> errors) {
        for (String errorMessage : errors) {
            errors.add(prefix + errorMessage);
        }
    }

    public void addErrors(Collection<String> errors) {
        this.addErrors("", errors);
    }

    @Override
    public Collection<UpgradeError> getErrors() {
        return this.errors;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    @Override
    public String getBuildNumber() {
        if (this.buildNumber == null) {
            String className = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
            this.buildNumber = className.replaceFirst("Build", "").replaceFirst("UpgradeTask", "");
        }
        return this.buildNumber;
    }
}

