/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate.support;

import com.atlassian.core.spool.SmartSpool;
import com.atlassian.core.spool.Spool;
import com.google.common.io.CountingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.hibernate.HibernateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.orm.hibernate.support.BlobInputStreamType;

public class SpoolingBlobInputStreamType
extends BlobInputStreamType {
    private static final Logger log = LoggerFactory.getLogger(SpoolingBlobInputStreamType.class);
    private Spool spool = SpoolingBlobInputStreamType.getDefaultSpool();

    private static Spool getDefaultSpool() {
        SmartSpool defaultSpool = new SmartSpool();
        defaultSpool.setThresholdBytes(131072);
        return defaultSpool;
    }

    public void setSpool(Spool spool) {
        this.spool = spool;
    }

    @Override
    protected Object nullSafeGetInternal(ResultSet rs, int index, LobHandler lobHandler) throws SQLException, IOException, HibernateException {
        try (InputStream is = (InputStream)super.nullSafeGetInternal(rs, index, lobHandler);){
            log.debug("Spooling data for blob get");
            InputStream inputStream = is == null ? null : this.spool.spool(is);
            return inputStream;
        }
    }

    @Override
    protected void nullSafeSetInternal(PreparedStatement ps, int index, Object value, LobCreator lobCreator) throws SQLException, IOException, HibernateException {
        if (value == null) {
            lobCreator.setBlobAsBinaryStream(ps, index, null, 0);
            return;
        }
        InputStream is = (InputStream)value;
        CountingInputStream countingStream = new CountingInputStream(is);
        if (log.isDebugEnabled()) {
            log.debug("Spooling data for blob set");
        }
        InputStream spooledStream = this.spool.spool((InputStream)countingStream);
        if (log.isDebugEnabled()) {
            log.debug("Spooled " + countingStream.getCount() + " bytes");
        }
        lobCreator.setBlobAsBinaryStream(ps, index, spooledStream, (int)countingStream.getCount());
    }
}

