/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.serialization;

import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.rest.api.model.RestList;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.deser.std.ContainerDeserializerBase;
import org.codehaus.jackson.type.JavaType;

public class RestListDeserializer
extends ContainerDeserializerBase {
    private final JsonDeserializer contentDeserializer;
    private final JavaType contentType;

    public RestListDeserializer(JsonDeserializer elementDeserializer, JavaType contentType) {
        super(PageResponse.class);
        this.contentDeserializer = (JsonDeserializer)Preconditions.checkNotNull((Object)elementDeserializer);
        this.contentType = (JavaType)Preconditions.checkNotNull((Object)contentType);
    }

    public JavaType getContentType() {
        return this.contentType;
    }

    public JsonDeserializer<Object> getContentDeserializer() {
        return this.contentDeserializer;
    }

    public RestList deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken token;
        int start = 0;
        int limit = 0;
        boolean hasMore = false;
        ImmutableList.Builder results = ImmutableList.builder();
        int openObjectCount = 1;
        while ((token = jsonParser.nextToken()) != null) {
            if (token == JsonToken.END_OBJECT) {
                --openObjectCount;
            } else if (token == JsonToken.START_OBJECT) {
                ++openObjectCount;
            }
            if (openObjectCount == 0) break;
            String name = jsonParser.getCurrentName();
            if ("results".equalsIgnoreCase(name)) {
                token = jsonParser.nextToken();
                Preconditions.checkState((boolean)token.equals((Object)JsonToken.START_ARRAY));
                while ((token = jsonParser.nextToken()) != JsonToken.END_ARRAY && token != null) {
                    Preconditions.checkState((boolean)token.equals((Object)JsonToken.START_OBJECT));
                    results.add(this.contentDeserializer.deserialize(jsonParser, deserializationContext));
                }
                continue;
            }
            if ("start".equalsIgnoreCase(name)) {
                jsonParser.nextToken();
                start = jsonParser.getIntValue();
                continue;
            }
            if ("limit".equalsIgnoreCase(name)) {
                jsonParser.nextToken();
                limit = jsonParser.getIntValue();
                continue;
            }
            if ("hasMore".equalsIgnoreCase(name)) {
                jsonParser.nextToken();
                hasMore = jsonParser.getBooleanValue();
                continue;
            }
            if (!"next".equalsIgnoreCase(name)) continue;
            jsonParser.nextToken();
            jsonParser.nextTextValue();
            hasMore = true;
        }
        SimplePageRequest request = new SimplePageRequest(start, limit);
        return RestList.createRestList((PageRequest)request, (List)results.build(), (boolean)hasMore);
    }
}

