/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.impl;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.service.content.ContentTrashService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteContentService;
import com.atlassian.confluence.rest.client.RemoteContentServiceImpl;
import com.atlassian.confluence.rest.client.RemoteContentTrashService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.util.concurrent.Promise;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;

public class RemoteContentTrashServiceImpl
extends AbstractRemoteService<ContentTrashService>
implements RemoteContentTrashService {
    private final RemoteContentService remoteContentService;

    public RemoteContentTrashServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, executor);
        this.remoteContentService = new RemoteContentServiceImpl(provider, executor);
    }

    @Override
    public Promise<Void> trash(Content content) {
        WebResource resource = this.getContentTrashWebResource().path(content.getId().serialise());
        return this.deleteFuture(resource);
    }

    @Override
    public Promise<Content> restore(Content content) {
        return this.remoteContentService.update(content);
    }

    @Override
    public Promise<Void> purge(Content content) {
        WebResource resource = this.getContentTrashWebResource().path(content.getId().serialise()).queryParam("status", "trashed");
        return this.deleteFuture(resource);
    }

    private WebResource getContentTrashWebResource() {
        return this.newRestWebResource().path("content");
    }
}

