/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.service.content.util;

import com.atlassian.confluence.api.service.content.util.ReconcileContentAsyncFlag;
import java.util.concurrent.Callable;

public class ReconcileContentAsyncOperations {
    private ReconcileContentAsyncOperations() {
    }

    public static <T> T callWithAsyncReconciliation(Callable<T> callable) {
        boolean wasAsync = ReconcileContentAsyncFlag.isAsync();
        ReconcileContentAsyncFlag.setAsync();
        try {
            T t = ReconcileContentAsyncOperations.callWithCheckedExceptionWrapping(callable);
            return t;
        }
        finally {
            if (!wasAsync) {
                ReconcileContentAsyncFlag.setSync();
            }
        }
    }

    public static <T> T callWithAsyncFlagAwareness(Callable<T> callable, boolean setAsyncFlag) {
        if (setAsyncFlag) {
            return ReconcileContentAsyncOperations.callWithAsyncReconciliation(callable);
        }
        return ReconcileContentAsyncOperations.callWithCheckedExceptionWrapping(callable);
    }

    private static <T> T callWithCheckedExceptionWrapping(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

