/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.search;

import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
@RestEnrichable
public class SearchPageResponse<T>
implements PageResponse<T> {
    @JsonProperty
    private final List<T> results;
    @JsonProperty
    private final boolean hasMore;
    @JsonProperty
    private final String cqlQuery;
    private final PageRequest pageRequest;
    @JsonProperty
    private final int totalSize;
    @JsonProperty
    private final int searchDuration;
    @JsonProperty
    private final Optional<Integer> archivedResultCount;

    @JsonCreator
    public SearchPageResponse(@JsonProperty(value="results") List<T> results, @JsonProperty(value="hasMore") boolean hasMore, @JsonProperty(value="cqlQuery") String cqlQuery, @JsonProperty(value="pageRequest") PageRequest pageRequest, @JsonProperty(value="totalSize") int totalSize, @JsonProperty(value="searchDuration") int searchDuration, @JsonProperty(value="archivedResultCount") Optional<Integer> archivedResultCount) {
        this.results = Collections.unmodifiableList(results);
        this.hasMore = hasMore;
        this.cqlQuery = cqlQuery;
        this.pageRequest = pageRequest;
        this.totalSize = totalSize;
        this.searchDuration = searchDuration;
        this.archivedResultCount = archivedResultCount;
    }

    private SearchPageResponse(Builder<T> builder) {
        this.results = Collections.unmodifiableList(new LinkedList(builder.results));
        this.hasMore = builder.hasMore;
        this.cqlQuery = builder.cqlQuery;
        this.pageRequest = builder.pageRequest;
        this.totalSize = builder.totalSize;
        this.searchDuration = builder.searchDuration;
        this.archivedResultCount = Optional.ofNullable(builder.archivedResultCount);
    }

    @Override
    public List<T> getResults() {
        return this.results;
    }

    @Override
    public int size() {
        return this.results.size();
    }

    public int totalSize() {
        return this.totalSize;
    }

    public int getSearchDuration() {
        return this.searchDuration;
    }

    @JsonProperty(value="archivedResultCount")
    public Optional<Integer> archivedResultCount() {
        return this.archivedResultCount;
    }

    @Override
    public boolean hasMore() {
        return this.hasMore;
    }

    @Override
    public PageRequest getPageRequest() {
        return this.pageRequest;
    }

    public String getCqlQuery() {
        return this.cqlQuery;
    }

    @Override
    public Iterator<T> iterator() {
        return this.results.iterator();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        public List<T> results = new LinkedList<T>();
        public boolean hasMore;
        public String cqlQuery = "";
        public PageRequest pageRequest;
        public int totalSize;
        public int searchDuration;
        public Integer archivedResultCount;

        private Builder() {
        }

        public SearchPageResponse<T> build() {
            return new SearchPageResponse(this);
        }

        public Builder<T> result(Iterable<T> results) {
            results.forEach(this.results::add);
            return this;
        }

        public Builder<T> hasMore(boolean hasMore) {
            this.hasMore = hasMore;
            return this;
        }

        public Builder<T> totalSize(int size) {
            this.totalSize = size;
            return this;
        }

        public Builder<T> cqlQuery(String query) {
            this.cqlQuery = query;
            return this;
        }

        public Builder<T> pageRequest(PageRequest pageRequest) {
            this.pageRequest = pageRequest;
            return this;
        }

        public Builder<T> searchDuration(int duration) {
            this.searchDuration = duration;
            return this;
        }

        public Builder<T> withArchivedResultCount(Optional<Integer> archivedResultCount) {
            this.archivedResultCount = archivedResultCount.orElse(null);
            return this;
        }
    }
}

