/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.content;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.api.model.content.Container;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.model.content.FormattedBody;
import com.atlassian.confluence.api.model.content.SpaceStatus;
import com.atlassian.confluence.api.model.content.SpaceType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.content.webresource.WebResourceDependencies;
import com.atlassian.confluence.api.model.link.Link;
import com.atlassian.confluence.api.model.link.LinkType;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.permissions.SpacePermissionContainer;
import com.atlassian.confluence.api.model.reference.BuilderUtils;
import com.atlassian.confluence.api.model.reference.EnrichableMap;
import com.atlassian.confluence.api.model.reference.ExpandedReference;
import com.atlassian.confluence.api.model.reference.ModelMapBuilder;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.model.relations.Relatable;
import com.atlassian.confluence.api.model.retention.SpaceRetentionPolicy;
import com.atlassian.confluence.api.model.web.Icon;
import com.atlassian.confluence.api.nav.Navigation;
import com.atlassian.confluence.api.nav.NavigationAware;
import com.atlassian.confluence.api.nav.NavigationService;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import com.atlassian.confluence.api.serialization.SwaggerEnrichExpandable;
import com.atlassian.confluence.api.serialization.SwaggerEnrichLinks;
import com.atlassian.confluence.api.serialization.jackson2.MetadataValueDeserializer;
import com.atlassian.confluence.api.serialization.jackson2.OffsetDateTimeDeserializer;
import com.atlassian.graphql.annotations.GraphQLIDType;
import com.atlassian.graphql.annotations.GraphQLName;
import com.atlassian.graphql.annotations.GraphQLTypeName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@RestEnrichable
@SwaggerEnrichLinks
@SwaggerEnrichExpandable
@JsonIgnoreProperties(ignoreUnknown=true)
public class Space
implements Container,
NavigationAware,
Relatable {
    @JsonProperty
    @GraphQLIDType
    @Schema(example="123456")
    private final Long id;
    @JsonProperty
    @Schema(example="TEST")
    private final String key;
    @JsonProperty
    @Schema(example="Test Space")
    private final String name;
    @JsonProperty
    @Schema(example="current")
    private final SpaceStatus status;
    @JsonDeserialize(as=ExpandedReference.class, contentAs=Icon.class)
    @JsonProperty
    @Schema
    private final Reference<Icon> icon;
    @JsonDeserialize(as=EnrichableMap.class)
    @JsonProperty
    @GraphQLTypeName(value="SpaceDescriptions")
    private final Map<ContentRepresentation, FormattedBody> description;
    @JsonDeserialize(as=ExpandedReference.class, contentAs=Content.class)
    @JsonProperty
    private final Reference<Content> homepage;
    @GraphQLName
    @Schema(example="123456")
    private final ContentId homepageId;
    @JsonProperty
    @GraphQLTypeName(value="ContentLinks")
    private final Map<LinkType, Link> links;
    @JsonProperty
    @Schema(example="global")
    private final SpaceType type;
    @JsonProperty
    @Schema
    private final Person creator;
    @JsonProperty
    @Schema(example="2024-01-01T00:00:00.000Z")
    @JsonDeserialize(using=OffsetDateTimeDeserializer.class)
    private final OffsetDateTime creationDate;
    @JsonProperty
    @Schema
    private final Person lastModifier;
    @JsonProperty
    @Schema(example="2024-01-01T00:00:00.000Z")
    @JsonDeserialize(using=OffsetDateTimeDeserializer.class)
    private final OffsetDateTime lastModificationDate;
    @JsonDeserialize(as=EnrichableMap.class, contentUsing=MetadataValueDeserializer.class)
    @JsonProperty
    @Schema(example="{\"labels\":[\"label1\",\"label2\"]}")
    private final Map<String, Object> metadata;
    @JsonDeserialize(as=ExpandedReference.class, contentAs=SpaceRetentionPolicy.class)
    @JsonProperty
    @Schema
    private final Reference<SpaceRetentionPolicy> retentionPolicy;
    @JsonDeserialize(as=ExpandedReference.class, contentAs=SpacePermissionContainer.class)
    @JsonProperty
    @Schema
    private final Reference<SpacePermissionContainer> permissions;

    public static String getSpaceKey(Reference<Space> reference) {
        return (String)reference.getIdProperty(IdProperties.key);
    }

    public static Reference<Space> buildReference(String spaceKey) {
        return Reference.collapsed(Space.class, Collections.singletonMap(IdProperties.key, spaceKey));
    }

    public static SpaceBuilder builder() {
        return new SpaceBuilder();
    }

    public static SpaceBuilder builder(Space space) {
        return Space.builder().name(space.name).status(space.status).key(space.key).id(space.getId()).icon(space.icon).description(space.description).homepage(space.homepage).type(space.type).creator(space.creator).creationDate(space.creationDate).lastModifier(space.lastModifier).lastModificationDate(space.lastModificationDate).metadata(space.metadata).retentionPolicy(space.retentionPolicy).permissions(space.permissions);
    }

    private Space(SpaceBuilder builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.key = builder.key;
        this.id = builder.id;
        this.icon = Reference.orEmpty(builder.icon, Icon.class);
        this.description = BuilderUtils.modelMap(builder.description);
        this.homepage = Reference.orEmpty(builder.homepage, Content.class);
        this.homepageId = Content.getSelector(builder.homepage).getId();
        this.links = Collections.unmodifiableMap(builder.links);
        this.type = builder.type;
        this.creator = builder.creator;
        this.creationDate = builder.creationDate;
        this.lastModifier = builder.lastModifier;
        this.lastModificationDate = builder.lastModificationDate;
        this.metadata = BuilderUtils.modelMap(builder.metadata);
        this.retentionPolicy = Reference.orEmpty(builder.retentionPolicy, SpaceRetentionPolicy.class);
        this.permissions = Reference.orEmpty(builder.permissions, SpacePermissionContainer.class);
    }

    @JsonCreator
    private Space() {
        this(Space.builder());
    }

    public long getId() {
        if (this.id == null) {
            return 0L;
        }
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public Reference<Icon> getIconRef() {
        return Reference.orEmpty(this.icon, Icon.class);
    }

    public Map<ContentRepresentation, FormattedBody> getDescription() {
        return this.description;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @JsonIgnore
    public Reference<SpacePermissionContainer> getPermissions() {
        return Reference.orEmpty(this.permissions, SpacePermissionContainer.class);
    }

    @Deprecated
    @JsonIgnore
    public Map<ContentRepresentation, Reference<FormattedBody>> getDescriptionRefs() {
        HashMap<ContentRepresentation, Reference<FormattedBody>> referenceMap = new HashMap<ContentRepresentation, Reference<FormattedBody>>();
        for (Map.Entry<ContentRepresentation, FormattedBody> entry : this.description.entrySet()) {
            referenceMap.put(entry.getKey(), Reference.to(entry.getValue()));
        }
        if (this.description instanceof EnrichableMap) {
            EnrichableMap enrichableMap = (EnrichableMap)this.description;
            for (ContentRepresentation representation : enrichableMap.getCollapsedEntries()) {
                Reference<FormattedBody> collapsed = Reference.collapsed(FormattedBody.class);
                referenceMap.put(representation, collapsed);
            }
        }
        return Collections.unmodifiableMap(referenceMap);
    }

    @JsonIgnore
    public Reference<Content> getHomepageRef() {
        return Reference.orEmpty(this.homepage, Content.class);
    }

    @JsonIgnore
    public Map<LinkType, Link> getLinks() {
        return this.links;
    }

    public SpaceType getType() {
        return this.type;
    }

    public Person getCreator() {
        return this.creator;
    }

    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    public Person getLastModifier() {
        return this.lastModifier;
    }

    public OffsetDateTime getLastModificationDate() {
        return this.lastModificationDate;
    }

    @Override
    public Navigation.Builder resolveNavigation(NavigationService navigationService) {
        return navigationService.createNavigation().space(this);
    }

    public String toString() {
        return "Space{key='" + this.key + '\'' + ", name='" + this.name + '\'' + '}';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Space)) {
            return false;
        }
        return Objects.equals(this.getKey(), ((Space)obj).getKey());
    }

    public int hashCode() {
        return Objects.hash(this.getKey());
    }

    public static class SpaceBuilder {
        private Long id = null;
        private String key = null;
        private String name = null;
        private SpaceStatus status = null;
        private Reference<Icon> icon = null;
        private ModelMapBuilder<ContentRepresentation, FormattedBody> description = ModelMapBuilder.newInstance();
        private Reference<Content> homepage = null;
        private final Map<LinkType, Link> links = new HashMap<LinkType, Link>();
        private SpaceType type = SpaceType.GLOBAL;
        private Person creator = null;
        private OffsetDateTime creationDate = null;
        private Person lastModifier = null;
        private OffsetDateTime lastModificationDate = null;
        private ModelMapBuilder<String, Object> metadata = ModelMapBuilder.newExpandedInstance();
        private Reference<SpaceRetentionPolicy> retentionPolicy = null;
        private Reference<SpacePermissionContainer> permissions = null;

        private SpaceBuilder() {
        }

        public Space build() {
            return new Space(this);
        }

        public SpaceBuilder description(ContentRepresentation representation, String value) {
            return this.description(representation, ((FormattedBody.FormattedBodyBuilder)((FormattedBody.FormattedBodyBuilder)((FormattedBody.FormattedBodyBuilder)FormattedBody.builder().representation(representation)).value(value)).webresource((Reference)Reference.empty(WebResourceDependencies.class))).build());
        }

        public SpaceBuilder description(ContentRepresentation representation, FormattedBody formattedBody) {
            this.description.put(representation, formattedBody);
            return this;
        }

        public SpaceBuilder description(Map<ContentRepresentation, FormattedBody> description) {
            this.description.copy(description);
            return this;
        }

        @Deprecated
        public SpaceBuilder description(ContentRepresentation representation, Reference<FormattedBody> formattedBody) {
            if (formattedBody.isExpanded()) {
                this.description(representation, formattedBody.get());
            }
            return this;
        }

        public SpaceBuilder icon(Icon icon) {
            this.icon = Reference.orEmpty(icon, Icon.class);
            return this;
        }

        public SpaceBuilder icon(Reference<Icon> iconRef) {
            this.icon = iconRef;
            return this;
        }

        public SpaceBuilder id(long id) {
            this.id = id;
            return this;
        }

        public SpaceBuilder key(String key) {
            this.key = key;
            return this;
        }

        public SpaceBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SpaceBuilder status(SpaceStatus status) {
            this.status = status;
            return this;
        }

        public SpaceBuilder homepage(Reference<Content> homepageRef) {
            this.homepage = homepageRef;
            return this;
        }

        public SpaceBuilder homepage(Content homepage) {
            this.homepage = Reference.to(homepage);
            return this;
        }

        public SpaceBuilder addLink(Link link) {
            this.links.put(link.getType(), link);
            return this;
        }

        public SpaceBuilder addLink(LinkType type, String path) {
            return this.addLink(new Link(type, path));
        }

        public SpaceBuilder type(SpaceType type) {
            this.type = type;
            return this;
        }

        public SpaceBuilder creator(Person creator) {
            this.creator = creator;
            return this;
        }

        public SpaceBuilder creationDate(OffsetDateTime creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public SpaceBuilder lastModifier(Person lastModifier) {
            this.lastModifier = lastModifier;
            return this;
        }

        public SpaceBuilder lastModificationDate(OffsetDateTime lastModificationDate) {
            this.lastModificationDate = lastModificationDate;
            return this;
        }

        public SpaceBuilder metadata(Map<String, Object> metadata) {
            this.metadata.copy(metadata);
            return this;
        }

        public SpaceBuilder retentionPolicy(SpaceRetentionPolicy retentionPolicy) {
            this.retentionPolicy = Reference.orEmpty(retentionPolicy, SpaceRetentionPolicy.class);
            return this;
        }

        public SpaceBuilder retentionPolicy(Reference<SpaceRetentionPolicy> retentionPolicyRef) {
            this.retentionPolicy = retentionPolicyRef;
            return this;
        }

        public SpaceBuilder permissions(Reference<SpacePermissionContainer> spacePermissions) {
            this.permissions = spacePermissions;
            return this;
        }
    }

    static enum IdProperties {
        key;

    }

    public static class Expansions {
        public static final String DESCRIPTION = "description";
        public static final String HOMEPAGE = "homepage";
        public static final String ICON = "icon";
        public static final String METADATA = "metadata";
        public static final String RETENTION_POLICY = "retentionPolicy";
        public static final String PERMISSION = "permissions";
        public static final String CREATOR = "creator";
        public static final String LAST_MODIFIER = "lastModifier";
    }

    @Internal
    public static class MetadataKeys {
        public static final String LABELS = "labels";
    }
}

