/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.people;

import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.relations.Relatable;
import com.atlassian.confluence.api.model.web.Icon;
import com.atlassian.sal.api.user.UserKey;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Optional;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown=true)
@JsonIgnoreProperties(ignoreUnknown=true)
public class User
extends Person
implements Relatable {
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    @Schema(example="user1")
    protected final String username;
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    @Schema(example="userkey[admin]")
    private final String userKey;

    @com.fasterxml.jackson.annotation.JsonCreator
    @JsonCreator
    private User() {
        super(null, "");
        this.username = null;
        this.userKey = null;
    }

    public User(Icon profilePicture, String username, String displayName, String userKey) {
        super(profilePicture, displayName);
        this.username = username;
        this.userKey = userKey != null ? userKey : "";
    }

    public User(Icon profilePicture, String username, String displayName, UserKey userKey) {
        this(profilePicture, username, displayName, userKey != null ? userKey.getStringValue() : "");
    }

    @Deprecated
    public User(Icon profilePicture, String username) {
        super(profilePicture);
        this.username = username;
        this.userKey = null;
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public Optional<String> optionalUsername() {
        if (this.getUsername() == null || this.getUsername().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.getUsername());
    }

    @Override
    @com.fasterxml.jackson.annotation.JsonIgnore
    @JsonIgnore
    public Optional<UserKey> optionalUserKey() {
        if (this.userKey == null || this.userKey.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new UserKey(this.userKey));
    }

    public String toString() {
        return "User{username='" + this.username + '\'' + ", userKey='" + this.userKey + '\'' + '}';
    }

    public static User fromUsername(String username) {
        return new User(null, username);
    }

    public static User fromUserkey(UserKey key) {
        return new User(null, null, null, key);
    }

    public static class Expansions {
        public static final String STATUS = "status";
    }
}

