/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.watch;

import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.model.reference.ExpandedReference;
import com.atlassian.confluence.api.model.reference.ModelListBuilder;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.model.watch.AbstractWatch;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.map.annotate.JsonDeserialize;

public class SpaceWatch
extends AbstractWatch {
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(as=ExpandedReference.class, contentAs=Space.class)
    @JsonDeserialize(as=ExpandedReference.class, contentAs=Space.class)
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    @Schema
    private final Reference<Space> space;
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    @Schema
    private final List<ContentType> contentTypes;

    public SpaceWatch(User watcher, String spaceKey, List<ContentType> contentTypes) {
        super(watcher);
        this.space = Reference.orEmpty(Space.builder().key(spaceKey).build(), Space.class);
        this.contentTypes = contentTypes;
    }

    @com.fasterxml.jackson.annotation.JsonCreator
    @JsonCreator
    public SpaceWatch(@JsonProperty(value="watcher") @org.codehaus.jackson.annotate.JsonProperty(value="watcher") @NonNull User watcher, @JsonProperty(value="space") @org.codehaus.jackson.annotate.JsonProperty(value="space") @NonNull Reference<Space> space, @JsonProperty(value="contentTypes") @org.codehaus.jackson.annotate.JsonProperty(value="contentTypes") List<ContentType> contentTypes) {
        super(watcher);
        this.space = space;
        this.contentTypes = contentTypes;
    }

    public SpaceWatch(SpaceWatchBuilder builder) {
        super(builder.watcher);
        this.space = builder.space;
        this.contentTypes = builder.contentTypes.build();
    }

    @Override
    public String toString() {
        return "SpaceWatch{space=" + this.space + ", watcher=" + this.getWatcher() + '}';
    }

    public Space getSpace() {
        return this.space.get();
    }

    public List<ContentType> getContentTypes() {
        return this.contentTypes;
    }

    public static SpaceWatchBuilder builder() {
        return new SpaceWatchBuilder();
    }

    public static class SpaceWatchBuilder {
        private Reference<Space> space;
        private ModelListBuilder<ContentType> contentTypes = ModelListBuilder.newExpandedInstance();
        private User watcher;

        public SpaceWatchBuilder space(Reference<Space> space) {
            this.space = space;
            return this;
        }

        public SpaceWatchBuilder contentList(Iterable<ContentType> contentTypes) {
            this.contentTypes.putAll(contentTypes);
            return this;
        }

        public SpaceWatchBuilder watcher(User watcher) {
            this.watcher = watcher;
            return this;
        }

        public SpaceWatch build() {
            return new SpaceWatch(this);
        }
    }
}

