/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.retention;

import com.atlassian.confluence.api.model.retention.RetentionPolicy;
import com.atlassian.confluence.api.model.retention.RetentionRule;
import com.atlassian.confluence.api.model.retention.TrashRetentionRule;
import com.atlassian.confluence.api.serialization.OffsetDateTimeDeserializer;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonDeserialize;

@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown=true)
@JsonIgnoreProperties(ignoreUnknown=true)
@RestEnrichable
public class SpaceRetentionPolicy
implements RetentionPolicy {
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    @Schema(example="true")
    private boolean spaceAdminCanEdit;
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    @Schema(example="2020-01-01T00:00:00.000Z")
    @JsonDeserialize(using=OffsetDateTimeDeserializer.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(using=com.atlassian.confluence.api.serialization.jackson2.OffsetDateTimeDeserializer.class)
    private OffsetDateTime lastModifiedDate = OffsetDateTime.now();
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    @Schema
    private RetentionRule pageRetentionRule = new RetentionRule();
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    @Schema
    private RetentionRule attachmentRetentionRule = new RetentionRule();
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    @Schema
    private TrashRetentionRule trashRetentionRule = new TrashRetentionRule();
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    @Schema(example="admin")
    private String lastModifiedBy;

    @Override
    public RetentionRule getPageVersionRule() {
        return this.pageRetentionRule;
    }

    @Override
    public RetentionRule getAttachmentRetentionRule() {
        return this.attachmentRetentionRule;
    }

    public void setTrashRetentionRule(TrashRetentionRule trashRetentionRule) {
        this.trashRetentionRule = trashRetentionRule;
    }

    @Override
    public TrashRetentionRule getTrashRetentionRule() {
        return this.trashRetentionRule;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    @com.fasterxml.jackson.annotation.JsonIgnore
    @JsonIgnore
    public OffsetDateTime getLastModifiedAt() {
        return this.lastModifiedDate;
    }

    @com.fasterxml.jackson.annotation.JsonIgnore
    @JsonIgnore
    public void setLastModifiedAt(OffsetDateTime lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    @Override
    public List<String> validate() {
        ArrayList<String> validations = new ArrayList<String>();
        validations.addAll(this.pageRetentionRule.validate());
        validations.addAll(this.attachmentRetentionRule.validate());
        validations.addAll(this.trashRetentionRule.validate());
        return validations;
    }

    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    public boolean getSpaceAdminCanEdit() {
        return this.spaceAdminCanEdit;
    }

    public void setSpaceAdminCanEdit(boolean spaceAdminCanEdit) {
        this.spaceAdminCanEdit = spaceAdminCanEdit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpaceRetentionPolicy that = (SpaceRetentionPolicy)o;
        return Objects.equals(this.spaceAdminCanEdit, that.spaceAdminCanEdit) && Objects.equals(this.pageRetentionRule, that.pageRetentionRule) && Objects.equals(this.attachmentRetentionRule, that.attachmentRetentionRule) && Objects.equals(this.trashRetentionRule, that.trashRetentionRule) && Objects.equals(this.lastModifiedBy, that.lastModifiedBy);
    }

    public int hashCode() {
        return Objects.hash(this.spaceAdminCanEdit, this.pageRetentionRule, this.attachmentRetentionRule, this.trashRetentionRule, this.lastModifiedBy);
    }

    public String toString() {
        return "SpaceRetentionPolicy{spaceAdminCanEdit=" + this.spaceAdminCanEdit + ", lastModifiedDate=" + this.lastModifiedDate + ", pageRetentionRule=" + this.pageRetentionRule + ", attachmentRetentionRule=" + this.attachmentRetentionRule + ", trashRetentionRule=" + this.trashRetentionRule + ", lastModifiedBy='" + this.lastModifiedBy + '\'' + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private RetentionRule pageRetentionRule = new RetentionRule();
        private RetentionRule attachmentRetentionRule = new RetentionRule();
        private TrashRetentionRule trashRetentionRule = new TrashRetentionRule();
        private boolean spaceAdminCanEdit;
        private String lastModifiedBy;
        private OffsetDateTime lastModifiedDate = OffsetDateTime.now();

        public Builder pageRetentionRule(RetentionRule pageRetentionRule) {
            this.pageRetentionRule = pageRetentionRule;
            return this;
        }

        public Builder attachmentRetentionRule(RetentionRule attachmentRetentionRule) {
            this.attachmentRetentionRule = attachmentRetentionRule;
            return this;
        }

        public Builder trashRetentionRule(TrashRetentionRule trashRetentionRule) {
            this.trashRetentionRule = trashRetentionRule;
            return this;
        }

        public Builder spaceAdminCanEdit(boolean spaceAdminCanEdit) {
            this.spaceAdminCanEdit = spaceAdminCanEdit;
            return this;
        }

        public Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public Builder lastModifiedDate(OffsetDateTime lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public SpaceRetentionPolicy build() {
            SpaceRetentionPolicy spaceRetentionPolicy = new SpaceRetentionPolicy();
            spaceRetentionPolicy.pageRetentionRule = this.pageRetentionRule;
            spaceRetentionPolicy.attachmentRetentionRule = this.attachmentRetentionRule;
            spaceRetentionPolicy.trashRetentionRule = this.trashRetentionRule;
            spaceRetentionPolicy.spaceAdminCanEdit = this.spaceAdminCanEdit;
            spaceRetentionPolicy.lastModifiedBy = this.lastModifiedBy;
            spaceRetentionPolicy.lastModifiedDate = this.lastModifiedDate;
            return spaceRetentionPolicy;
        }
    }
}

