/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.locator;

import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.locator.ContentLocatorBuilder;
import com.atlassian.confluence.api.model.locator.LocalDateArrayDeserializer;
import com.atlassian.confluence.api.model.locator.LocalDateArrayDeserializerJackson2;
import com.atlassian.confluence.api.model.locator.LocalDateArraySerializer;
import com.atlassian.confluence.api.model.locator.LocalDateArraySerializerJackson2;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.LocalDate;
import java.util.Arrays;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;

public final class ContentLocator {
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    private final String title;
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    private final String spaceKey;
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonSerialize(using=LocalDateArraySerializerJackson2.class)
    @org.codehaus.jackson.map.annotate.JsonSerialize(using=LocalDateArraySerializer.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(using=LocalDateArrayDeserializerJackson2.class)
    @JsonDeserialize(using=LocalDateArrayDeserializer.class)
    private final LocalDate postingDay;
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    private final ContentType[] contentTypes;

    public static ContentLocatorBuilder builder() {
        return new ContentLocatorBuilder();
    }

    @com.fasterxml.jackson.annotation.JsonCreator
    @JsonCreator
    private ContentLocator() {
        this.title = null;
        this.spaceKey = null;
        this.postingDay = null;
        this.contentTypes = null;
    }

    ContentLocator(String title, String spaceKey, LocalDate postingDay, ContentType ... contentTypes) {
        this.title = title;
        this.spaceKey = spaceKey;
        this.postingDay = postingDay;
        this.contentTypes = contentTypes;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    @com.fasterxml.jackson.annotation.JsonIgnore
    @JsonIgnore
    public LocalDate getPostingDate() {
        return this.postingDay;
    }

    public ContentType[] getContentTypes() {
        return this.contentTypes == null ? null : Arrays.copyOf(this.contentTypes, this.contentTypes.length);
    }

    public boolean isForContent(ContentType contentType) {
        return this.contentTypes != null && this.contentTypes.length == 1 && this.contentTypes[0].equals(contentType);
    }
}

