/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.people;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.people.KnownUser;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.web.Icon;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

@ExperimentalApi
public abstract class User
extends Person {
    @JsonProperty
    protected final String username;
    @JsonProperty
    private final String userKey;
    public static final Function<User, String> mapUserToUsername = user -> ((User)Preconditions.checkNotNull((Object)user)).getUsername();
    public static final Predicate<User> isUserKnown = user -> user instanceof KnownUser;

    public User(Icon profilePicture, String username, String displayName, String userKey) {
        super(profilePicture, displayName);
        this.username = username;
        this.userKey = userKey != null ? userKey : "";
    }

    public User(Icon profilePicture, String username, String displayName, UserKey userKey) {
        this(profilePicture, username, displayName, userKey != null ? userKey.getStringValue() : "");
    }

    @Deprecated
    public User(Icon profilePicture, String username) {
        super(profilePicture);
        this.username = username;
        this.userKey = null;
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public Option<String> getOptionalUsername() {
        if (Strings.isNullOrEmpty((String)this.getUsername())) {
            return Option.none();
        }
        return Option.some((Object)this.getUsername());
    }

    @Override
    @JsonIgnore
    public Option<UserKey> getUserKey() {
        if (Strings.isNullOrEmpty((String)this.userKey)) {
            return Option.none();
        }
        return Option.some((Object)new UserKey(this.userKey));
    }
}

