/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.web;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.web.WebItemView;
import com.atlassian.soy.renderer.CustomSoyDataMapper;
import com.google.common.collect.ImmutableList;
import org.codehaus.jackson.annotate.JsonProperty;

@ExperimentalApi
@CustomSoyDataMapper(value="jackson2soy")
public class WebSectionView {
    @JsonProperty
    private final String id;
    @JsonProperty
    private final String label;
    @JsonProperty
    private Iterable<WebItemView> items;
    @JsonProperty
    private String styleClass;

    private WebSectionView(String id, String label) {
        this.id = id;
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String getId() {
        return this.id;
    }

    public Iterable<WebItemView> getLinks() {
        return this.items;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public static class Builder {
        private ImmutableList.Builder<WebItemView> items = ImmutableList.builder();
        private String styleClass;

        public Builder setStyleClass(String styleClass) {
            this.styleClass = styleClass;
            return this;
        }

        public Builder addItems(WebItemView ... items) {
            this.items.add((Object[])items);
            return this;
        }

        public Builder addItems(Iterable<WebItemView> items) {
            this.items.addAll(items);
            return this;
        }

        public WebSectionView create(String id, String label) {
            WebSectionView section = new WebSectionView(id, label);
            section.items = (Iterable)this.items.build();
            section.styleClass = this.styleClass;
            return section;
        }
    }
}

