/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.validation;

import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.ConflictException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import javax.annotation.Nullable;

public class ServiceExceptionSupplier {
    public static Function<String, NotFoundException> notFoundException() {
        return new Function<String, NotFoundException>(){

            public NotFoundException apply(String errorMsg) {
                return new NotFoundException(errorMsg);
            }
        };
    }

    public static Supplier<NotFoundException> notFoundException(final String errorMsg) {
        return new Supplier<NotFoundException>(){

            public NotFoundException get() {
                return new NotFoundException(errorMsg);
            }
        };
    }

    public static Function<String, ConflictException> conflictException() {
        return new Function<String, ConflictException>(){

            public ConflictException apply(String errorMsg) {
                return new ConflictException(errorMsg);
            }
        };
    }

    public static Function<String, ? extends ServiceException> notImplemented() {
        return new Function<String, ServiceException>(){

            public ServiceException apply(@Nullable String input) {
                return new NotImplementedServiceException(input);
            }
        };
    }

    public static Function<String, ? extends ServiceException> badRequestException() {
        return new Function<String, ServiceException>(){

            public ServiceException apply(@Nullable String input) {
                return new BadRequestException(input);
            }
        };
    }
}

