/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.reference;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.api.model.reference.ModelMapBuilder;
import com.atlassian.confluence.api.nav.Navigation;
import com.atlassian.confluence.api.nav.NavigationAware;
import com.atlassian.confluence.api.nav.NavigationService;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;

@RestEnrichable
@Internal
public class EnrichableMap<K, V>
extends AbstractMap<K, V>
implements NavigationAware {
    private final ImmutableMap<K, V> delegate;
    private final ImmutableSet<K> collapsedEntries;
    private final Navigation.Builder navBuilder;

    private EnrichableMap() {
        this.collapsedEntries = ImmutableSet.of();
        this.delegate = ImmutableMap.of();
        this.navBuilder = null;
    }

    EnrichableMap(ModelMapBuilder<K, V> builder) {
        this(builder, null);
    }

    EnrichableMap(ModelMapBuilder<K, V> builder, Navigation.Builder navBuilder) {
        this.delegate = builder.buildDelegate();
        this.collapsedEntries = builder.collapsedEntries.build();
        this.navBuilder = navBuilder;
    }

    @Override
    public Navigation.Builder resolveNavigation(NavigationService navigationService) {
        return this.navBuilder;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    public Set<K> getCollapsedEntries() {
        return this.collapsedEntries;
    }
}

