/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.reference;

import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.reference.Collapsed;
import com.atlassian.confluence.api.model.reference.CollapsedList;
import com.atlassian.confluence.api.model.reference.CollapsedMap;
import com.atlassian.confluence.api.model.reference.EnrichableMap;
import com.atlassian.confluence.api.model.reference.ModelMapBuilder;
import com.atlassian.confluence.api.nav.Navigation;
import com.atlassian.confluence.api.nav.NavigationAware;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class BuilderUtils {
    public static <T> List<T> immutableListOrCollapsed(ImmutableList.Builder<T> builder) {
        if (builder != null) {
            return builder.build();
        }
        return new CollapsedList();
    }

    public static <T> PageResponse<T> collapsedPageResponse(Navigation.Builder navBuilder) {
        return new CollapsedList(navBuilder);
    }

    public static <K, V> Map<K, V> collapsedMap() {
        return BuilderUtils.collapsedMap(null);
    }

    public static <K, V> Map<K, V> collapsedMap(Navigation.Builder navBuilder) {
        return new CollapsedMap(navBuilder);
    }

    public static <K, V> Map<K, V> modelMap(ModelMapBuilder<K, V> mapBuilder) {
        Map<K, V> map = mapBuilder != null ? mapBuilder.build() : null;
        return BuilderUtils.modelMap(map);
    }

    @Deprecated
    public static <K, V> Map<K, V> modelMap(ImmutableMap.Builder<K, V> mapBuilder) {
        ImmutableMap map = mapBuilder != null ? mapBuilder.build() : null;
        return BuilderUtils.modelMap(map);
    }

    public static <K, V> Map<K, V> modelMap(Map<K, V> map) {
        if (map == null) {
            return new CollapsedMap();
        }
        if (map instanceof NavigationAware || map instanceof EnrichableMap) {
            return map;
        }
        ModelMapBuilder<K, V> builder = ModelMapBuilder.newInstance();
        return builder.putAll(map).build();
    }

    @Deprecated
    public static <K, V> ImmutableMap.Builder<K, V> safelyPutToBuilder(ImmutableMap.Builder<K, V> mapBuilder, K key, V value) {
        if (mapBuilder == null) {
            mapBuilder = ImmutableMap.builder();
        }
        if (key != null && value != null) {
            mapBuilder.put(key, value);
        }
        return mapBuilder;
    }

    @Deprecated
    public static <K, V> ImmutableMap.Builder<K, V> safelyPutAllToBuilder(ImmutableMap.Builder<K, V> mapBuilder, Map<K, V> toAdd) {
        if (mapBuilder == null) {
            mapBuilder = ImmutableMap.builder();
        }
        if (toAdd == null || toAdd instanceof Collapsed) {
            return mapBuilder;
        }
        mapBuilder.putAll(toAdd);
        return mapBuilder;
    }

    public static <T> ImmutableList.Builder<T> safelyAddAllToBuilder(ImmutableList.Builder<T> listBuilder, Iterable<T> toAdd) {
        if (listBuilder == null) {
            listBuilder = ImmutableList.builder();
        }
        if (toAdd == null || toAdd instanceof Collapsed) {
            return listBuilder;
        }
        listBuilder.addAll(toAdd);
        return listBuilder;
    }
}

