/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.permissions;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.ApiEnum;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonValue;

@ExperimentalApi
public final class OperationKey
implements ApiEnum {
    public static final OperationKey USE = new OperationKey("use");
    public static final OperationKey CREATE = new OperationKey("create");
    public static final OperationKey READ = new OperationKey("read");
    public static final OperationKey UPDATE = new OperationKey("update");
    public static final OperationKey DELETE = new OperationKey("delete");
    public static final OperationKey COPY = new OperationKey("copy");
    public static final OperationKey MOVE = new OperationKey("move");
    public static final OperationKey EXPORT = new OperationKey("export");
    public static final OperationKey PURGE = new OperationKey("purge");
    public static final OperationKey PURGE_VERSION = new OperationKey("purge_version");
    public static final List<OperationKey> BUILT_IN = ImmutableList.of((Object)USE, (Object)CREATE, (Object)READ, (Object)UPDATE, (Object)DELETE, (Object)COPY, (Object)MOVE, (Object)EXPORT, (Object)PURGE, (Object)PURGE_VERSION);
    private final String name;

    @JsonCreator
    public static OperationKey valueOf(String name) {
        for (OperationKey operationKey : BUILT_IN) {
            if (!operationKey.name.equals(name)) continue;
            return operationKey;
        }
        return new OperationKey(name);
    }

    private OperationKey(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        return obj instanceof OperationKey && this.name.equals(((OperationKey)obj).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String serialise() {
        return this.toString();
    }
}

