/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.messages;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.messages.Message;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.ser.std.ToStringSerializer;

@JsonIgnoreProperties(ignoreUnknown=true)
@ExperimentalApi
public class SimpleMessage
implements Message {
    @JsonProperty
    private final String key;
    @JsonDeserialize(contentAs=String.class)
    @JsonSerialize(contentUsing=ToStringSerializer.class)
    @JsonProperty
    private final List<Object> args;
    @JsonProperty
    private final String translation;

    @JsonCreator
    private SimpleMessage() {
        this.key = null;
        this.args = null;
        this.translation = null;
    }

    private SimpleMessage(String translation, String key, Object ... args) {
        this.translation = translation;
        this.key = key;
        this.args = args != null ? ImmutableList.copyOf((Object[])args) : ImmutableList.of();
    }

    public static SimpleMessage withKeyAndArgs(String key, Object ... args) {
        return new SimpleMessage(null, key, args);
    }

    public static SimpleMessage withTranslation(String translation) {
        return new SimpleMessage(translation, null, new Object[0]);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Object[] getArgs() {
        return this.args.toArray();
    }

    @Override
    public String getTranslation() {
        return this.translation;
    }

    public static SimpleMessage copyOf(Message message) {
        return new SimpleMessage(message.getTranslation(), message.getKey(), message.getArgs());
    }

    public String toString() {
        return "SimpleMessage{key='" + this.key + '\'' + ", args=" + this.args + ", translation='" + this.translation + '\'' + '}';
    }
}

