/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.Expansion;
import com.google.common.base.Objects;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@ExperimentalApi
public class Expansions {
    public static final Expansions EMPTY = new Expansions(Collections.<String, Expansions>emptyMap());
    private final Map<String, Expansions> expansionsMap;

    public Expansions(Expansion ... expansions) {
        this(Expansions.merge(new HashMap<String, Expansions>(), expansions));
    }

    public Expansions(Iterable<Expansion> expansions) {
        this((Expansion[])Iterables.toArray(expansions, Expansion.class));
    }

    public static Expansions of(String ... expansionStr) {
        return new Expansions(Collections2.transform(Arrays.asList(expansionStr), Expansion.AS_EXPANSION).toArray(new Expansion[0]));
    }

    public Expansions merge(Expansions expansions) {
        return new Expansions(Expansions.merge(this.expansionsMap, expansions.toArray()));
    }

    public Expansion[] merge(Expansion[] expansions) {
        return new Expansions(Expansions.merge(this.expansionsMap, expansions)).toArray();
    }

    private Expansions(Map<String, Expansions> expansionsMap) {
        this.expansionsMap = ImmutableMap.copyOf(expansionsMap);
    }

    private static Map<String, Expansions> merge(Map<String, Expansions> existingMap, Expansion ... incomingExpansions) {
        HashMap<String, Expansions> mutableExistingMap = new HashMap<String, Expansions>(existingMap);
        for (Expansion incomingExpansion : incomingExpansions) {
            Expansions incomingSubExpansions;
            Expansions mergedSubExpansions = incomingSubExpansions = incomingExpansion.getSubExpansions();
            String name = incomingExpansion.getPropertyName();
            Expansions existingSubExpansions = (Expansions)mutableExistingMap.get(name);
            if (existingSubExpansions != null) {
                Map<String, Expansions> mergedMap = Expansions.merge(existingSubExpansions.expansionsMap, incomingSubExpansions.toArray());
                mergedSubExpansions = new Expansions(mergedMap);
                mutableExistingMap.put(name, mergedSubExpansions);
            }
            mutableExistingMap.put(name, mergedSubExpansions);
        }
        return mutableExistingMap;
    }

    public boolean canExpand(String propertyName) {
        return this.expansionsMap.containsKey(propertyName);
    }

    public Expansions getSubExpansions(String propertyName) {
        return this.canExpand(propertyName) ? this.expansionsMap.get(propertyName) : EMPTY;
    }

    public Expansions prepend(String propertyName) {
        return new Expansions(new Expansion(propertyName, this));
    }

    public Expansion[] toArray() {
        Expansion[] array = new Expansion[this.expansionsMap.size()];
        int i = 0;
        for (Map.Entry<String, Expansions> stringExpansionsEntry : this.expansionsMap.entrySet()) {
            array[i++] = new Expansion(stringExpansionsEntry.getKey(), stringExpansionsEntry.getValue());
        }
        return array;
    }

    public boolean isEmpty() {
        return this.expansionsMap.isEmpty();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("map", this.expansionsMap).toString();
    }

    public void checkRecursiveExpansion(String expansion) {
        if (this.canExpand(expansion)) {
            throw new IllegalArgumentException("Cannot recursively expand : " + expansion);
        }
        for (Expansions exp : this.expansionsMap.values()) {
            exp.checkRecursiveExpansion(expansion);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Expansions that = (Expansions)o;
        return !(this.expansionsMap == null ? that.expansionsMap != null : !((Object)this.expansionsMap).equals(that.expansionsMap));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.expansionsMap});
    }
}

