/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hibernate;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.spring.AutomaticJdbcExtractor;
import com.atlassian.spring.LobSelector;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.jdbc.support.lob.OracleLobHandler;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;

public class OracleLobSelector
extends LobSelector {
    private static final boolean enabled = true;
    private AutomaticJdbcExtractor automaticJdbcExtractor;
    private LobHandler selectedLobHandler;

    public void setAutomaticJdbcExtractor(AutomaticJdbcExtractor automaticJdbcExtractor) {
        this.automaticJdbcExtractor = automaticJdbcExtractor;
    }

    public LobHandler getLobHandler() {
        if (this.selectedLobHandler == null) {
            if (this.isOracleDialect()) {
                OracleLobHandler oracleobHandler = null;
                try {
                    oracleobHandler = (OracleLobHandler)Class.forName("org.springframework.jdbc.support.lob.OracleLobHandler").newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not instantiate OracleLobHandler", e);
                }
                oracleobHandler.setNativeJdbcExtractor((NativeJdbcExtractor)this.automaticJdbcExtractor);
                this.selectedLobHandler = oracleobHandler;
            } else {
                this.selectedLobHandler = super.getLobHandler();
            }
        }
        return this.selectedLobHandler;
    }

    private boolean isOracleDialect() {
        String dialect = BootstrapUtils.getBootstrapManager().getString("hibernate.dialect");
        return StringUtils.contains((CharSequence)dialect, (CharSequence)"Oracle");
    }
}

