/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hibernate;

import bucket.core.persistence.ObjectDao;
import com.atlassian.bonnie.Indexer;
import com.atlassian.bonnie.Searchable;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.core.exception.InfrastructureException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.ReplicationMode;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Logger;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

public abstract class HibernateObjectDao
extends HibernateDaoSupport
implements ObjectDao {
    @Deprecated
    protected static final Logger log = Logger.getLogger(HibernateObjectDao.class);
    private Indexer indexer;

    public void setIndexer(Indexer indexer) {
        this.indexer = indexer;
    }

    protected EntityObject getByClassId(final long id) {
        EntityObject obj = (EntityObject)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.get(HibernateObjectDao.this.getPersistentClass(), (Serializable)new Long(id));
            }
        });
        return obj;
    }

    @Override
    public List findAll() {
        return this.findAllSorted(null);
    }

    @Override
    public List findAllSorted(String sortField) {
        return this.findAllSorted(sortField, true, 0, -1);
    }

    @Override
    public List findAllSorted(String sortField, final boolean cacheable, final int offset, final int maxResultCount) {
        String query = "FROM " + this.getPersistentClass().getName() + " result";
        if (sortField != null) {
            query = query + " ORDER BY LOWER(result." + sortField + ")";
        }
        final String finalQuery = query;
        List result = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery(finalQuery);
                queryObject.setCacheable(cacheable);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateObjectDao.this.getSessionFactory());
                queryObject.setFirstResult(offset);
                if (maxResultCount != -1) {
                    queryObject.setMaxResults(maxResultCount);
                }
                return queryObject.list();
            }
        });
        if (result == null) {
            return Collections.EMPTY_LIST;
        }
        return result;
    }

    @Override
    public void save(EntityObject objectToSave) {
        this.updateModificationData(objectToSave);
        this.saveRaw(objectToSave);
    }

    protected void updateModificationData(EntityObject objectToSave) {
        Date date = objectToSave.getCurrentDate();
        objectToSave.setLastModificationDate(date);
        if (objectToSave.getCreationDate() == null) {
            objectToSave.setCreationDate(date);
        }
    }

    @Override
    public void saveRaw(EntityObject objectToSave) {
        this.getHibernateTemplate().saveOrUpdate((Object)objectToSave);
        this.reIndex(objectToSave);
    }

    @Override
    public void remove(EntityObject objectToRemove) {
        try {
            this.getHibernateTemplate().delete((Object)objectToRemove);
            this.unIndex(objectToRemove, true);
        }
        catch (Exception e) {
            log.error((Object)"remove error!", (Throwable)e);
            throw new InfrastructureException((Throwable)e);
        }
    }

    @Override
    public void refresh(final EntityObject objectToRefresh) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.refresh((Object)objectToRefresh);
                return null;
            }
        });
    }

    @Override
    public void replicate(final Object objectToReplicate) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.replicate(objectToReplicate, ReplicationMode.OVERWRITE);
                return null;
            }
        });
    }

    protected void index(EntityObject objectToSave) {
        try {
            if (this.indexer != null && objectToSave instanceof Searchable) {
                this.indexer.index((Searchable)objectToSave);
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to index object: " + objectToSave + " -- " + e.getMessage()), (Throwable)e);
        }
    }

    protected void reIndex(EntityObject objectToSave) {
        try {
            if (this.indexer != null && objectToSave instanceof Searchable) {
                this.indexer.reIndex((Searchable)objectToSave);
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to reIndex object: " + objectToSave + " -- " + e.getMessage()), (Throwable)e);
        }
    }

    protected void unIndex(EntityObject objectToSave, boolean unindexDependents) {
        try {
            if (this.indexer != null && objectToSave instanceof Searchable) {
                if (unindexDependents) {
                    Iterator it = ((Searchable)objectToSave).getSearchableDependants().iterator();
                    while (it.hasNext()) {
                        this.unIndex((EntityObject)it.next(), true);
                    }
                }
                this.indexer.unIndex((Searchable)objectToSave);
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to index object: " + objectToSave + " -- " + e.getMessage()), (Throwable)e);
        }
    }

    protected List findNamedQuery(String queryName) {
        return this.findNamedQueryStringParams(queryName, true, 0, -1, new Object[0]);
    }

    protected List findNamedQuery(String queryName, boolean cacheable) {
        return this.findNamedQueryStringParams(queryName, cacheable, 0, -1, new Object[0]);
    }

    protected List findNamedQuery(String queryName, boolean cacheable, int maxResultCount) {
        return this.findNamedQueryStringParams(queryName, cacheable, 0, maxResultCount, new Object[0]);
    }

    protected List findNamedQueryStringParam(String queryName, String paramName, Object paramValue) {
        return this.findNamedQueryStringParams(queryName, true, 0, -1, paramName, paramValue);
    }

    protected List findNamedQueryStringParam(String queryName, String paramName, Object paramValue, boolean cacheable) {
        return this.findNamedQueryStringParams(queryName, cacheable, 0, -1, paramName, paramValue);
    }

    protected List findNamedQueryStringParam(String queryName, String paramName, Object paramValue, boolean cacheable, int maxResultCount) {
        return this.findNamedQueryStringParams(queryName, cacheable, 0, maxResultCount, paramName, paramValue);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value) {
        return this.findNamedQueryStringParams(queryName, true, 0, -1, paramName, paramValue, param2Name, param2Value);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, boolean cacheable) {
        return this.findNamedQueryStringParams(queryName, cacheable, 0, -1, paramName, paramValue, param2Name, param2Value);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, boolean cacheable, int maxResultCount) {
        return this.findNamedQueryStringParams(queryName, cacheable, 0, maxResultCount, paramName, paramValue, param2Name, param2Value);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value) {
        return this.findNamedQueryStringParams(queryName, true, 0, -1, paramName, paramValue, param2Name, param2Value, param3Name, param3Value);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value, boolean cacheable) {
        return this.findNamedQueryStringParams(queryName, cacheable, 0, -1, paramName, paramValue, param2Name, param2Value, param3Name, param3Value);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value, boolean cacheable, int maxResultCount) {
        return this.findNamedQueryStringParams(queryName, cacheable, 0, maxResultCount, paramName, paramValue, param2Name, param2Value, param3Name, param3Value);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value, String param4Name, Object param4Value) {
        return this.findNamedQueryStringParams(queryName, true, 0, -1, paramName, paramValue, param2Name, param2Value, param3Name, param3Value, param4Name, param4Value);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value, String param4Name, Object param4Value, boolean cacheable) {
        return this.findNamedQueryStringParams(queryName, cacheable, 0, -1, paramName, paramValue, param2Name, param2Value, param3Name, param3Value, param4Name, param4Value);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value, String param4Name, Object param4Value, boolean cacheable, int maxResultCount) {
        return this.findNamedQueryStringParams(queryName, cacheable, 0, maxResultCount, paramName, paramValue, param2Name, param2Value, param3Name, param3Value, param4Name, param4Value);
    }

    protected List findNamedQueryStringParams(final String queryName, final boolean cacheable, final int offset, final int maxResultCount, final Object ... paramNamesAndValues) {
        if (paramNamesAndValues.length % 2 == 1) {
            throw new IllegalArgumentException("There must be an even number of parameter names and values.");
        }
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery(queryName);
                if (cacheable) {
                    queryObject.setCacheable(true);
                }
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateObjectDao.this.getSessionFactory());
                for (int i = 0; i < paramNamesAndValues.length; i += 2) {
                    String paramName = (String)paramNamesAndValues[i];
                    if (paramName == null) {
                        throw new IllegalArgumentException("Parameter names cannot be null.");
                    }
                    Object paramValue = paramNamesAndValues[i + 1];
                    if (paramValue instanceof Collection) {
                        Collection collection = (Collection)paramValue;
                        if (collection.isEmpty()) {
                            throw new IllegalArgumentException("Encountered empty collection for parameter: " + paramName + ". Hibernate does not support empty brackets after the sql 'in' clause.");
                        }
                        queryObject.setParameterList(paramName, collection);
                        continue;
                    }
                    queryObject.setParameter(paramName, paramValue);
                }
                queryObject.setFirstResult(offset);
                if (maxResultCount != -1) {
                    queryObject.setMaxResults(maxResultCount);
                }
                return queryObject.list();
            }
        });
    }

    protected int getCountResult(List<Integer> results) {
        if (results == null || results.isEmpty()) {
            log.error((Object)"Uh oh spaghettio - found no results for a count() query");
            return 0;
        }
        int result = results.get(0);
        if (results.size() != 1) {
            log.error((Object)("Uh oh - found more than one result when count query run: " + results));
        }
        return result;
    }

    protected <T extends EntityObject> T findSingleObject(List<T> results) {
        if (results == null || results.isEmpty()) {
            return null;
        }
        EntityObject result = (EntityObject)results.get(0);
        if (results.size() != 1) {
            log.error((Object)("Uh oh - found more than one object when single object requested: " + results));
            for (EntityObject entity : results) {
                if (entity.getId() >= result.getId()) continue;
                result = entity;
            }
        }
        return (T)result;
    }
}

