/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hibernate;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.id.IdentifierGenerationException;
import net.sf.hibernate.id.TableGenerator;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.PropertiesHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResettableTableHiLoGenerator
extends TableGenerator {
    public static final String MAX_LO = "max_lo";
    private long hi;
    private int lo;
    private int maxLo;
    private Class returnClass;
    private static final Log log = LogFactory.getLog(ResettableTableHiLoGenerator.class);

    public void configure(Type type, Properties params, Dialect d) {
        super.configure(type, params, d);
        this.maxLo = PropertiesHelper.getInt((String)MAX_LO, (Properties)params, (int)Short.MAX_VALUE);
        this.lo = this.maxLo + 1;
        this.returnClass = type.getReturnedClass();
    }

    public int getMaxLo() {
        return this.maxLo;
    }

    public synchronized Serializable generate(SessionImplementor session, Object obj) throws SQLException, HibernateException {
        if (this.lo > this.maxLo) {
            int hival = (Integer)super.generate(session, obj);
            this.lo = 1;
            this.hi = hival * (this.maxLo + 1);
            log.debug((Object)("new hi value: " + hival));
        }
        return ResettableTableHiLoGenerator.createNumber(this.hi + (long)this.lo++, this.returnClass);
    }

    public synchronized void reset() {
        this.lo = this.maxLo + 1;
    }

    private static Number createNumber(long value, Class clazz) throws IdentifierGenerationException {
        if (clazz == Long.class) {
            return new Long(value);
        }
        if (clazz == Integer.class) {
            return new Integer((int)value);
        }
        if (clazz == Short.class) {
            return new Short((short)value);
        }
        throw new IdentifierGenerationException("this id generator generates long, integer, short");
    }
}

