/*
 * Decompiled with CFR 0.152.
 */
package bucket.search.persistence.dao.hibernate;

import bucket.search.persistence.IndexQueueEntry;
import bucket.search.persistence.dao.IndexQueueEntryDao;
import com.atlassian.hibernate.HibernateObjectDao;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class HibernateIndexQueueEntryDao
extends HibernateObjectDao
implements IndexQueueEntryDao {
    @Deprecated
    public static final Category LOG = Category.getInstance(HibernateIndexQueueEntryDao.class);
    private static final Logger log = LoggerFactory.getLogger(HibernateIndexQueueEntryDao.class);

    @Override
    public Class getPersistentClass() {
        return IndexQueueEntry.class;
    }

    @Override
    public void saveOrUpdate(IndexQueueEntry entry) {
        if (entry.getCreationDate() == null) {
            entry.setCreationDate(new Date());
        }
        this.getHibernateTemplate().saveOrUpdate((Object)entry);
    }

    @Override
    public List<IndexQueueEntry> getNewEntries(Date since) {
        return this.getHibernateTemplate().find("from IndexQueueEntry where CREATIONDATE > ? order by CREATIONDATE, ENTRYID", (Object)since);
    }

    @Override
    public int getNewEntryCount(final Date since) {
        Integer count = (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("select count(*) from IndexQueueEntry where creationDate >= :creationDate");
                queryObject.setTimestamp("creationDate", since);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateIndexQueueEntryDao.this.getSessionFactory());
                return queryObject.uniqueResult();
            }
        });
        return count;
    }

    @Override
    public void deleteAllBefore(final Date since) {
        this.executeSqlDelete(new SQLDeleteAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(Connection con) throws SQLException {
                PreparedStatement ps = null;
                try {
                    ps = con.prepareStatement("delete from INDEXQUEUEENTRIES where CREATIONDATE < ?");
                    ps.setTimestamp(1, new Timestamp(since.getTime()));
                    int rowsDeleted = ps.executeUpdate();
                    if (rowsDeleted > 0 && log.isDebugEnabled()) {
                        log.debug(rowsDeleted + " entried deleted from the INDEX QUEUE ENTRIES table.");
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
        });
    }

    @Override
    public void deleteAll() {
        this.executeSqlDelete(new SQLDeleteAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(Connection con) throws SQLException {
                PreparedStatement ps = null;
                try {
                    ps = con.prepareStatement("delete from INDEXQUEUEENTRIES");
                    ps.executeUpdate();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
        });
    }

    private void executeSqlDelete(final SQLDeleteAction action) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Connection connection = session.connection();
                try {
                    session.flush();
                    action.execute(connection);
                    HibernateIndexQueueEntryDao.this.getSessionFactory().evict(IndexQueueEntry.class);
                }
                catch (SQLException e) {
                    throw new HibernateException((Throwable)e);
                }
                return null;
            }
        });
    }

    private static interface SQLDeleteAction {
        public void execute(Connection var1) throws SQLException;
    }
}

