/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.quartz.jobs;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.quartz.QuartzUtil;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.LocaleProvider;
import com.opensymphony.xwork.TextProvider;
import com.opensymphony.xwork.TextProviderSupport;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.orm.hibernate.SessionHolder;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class AbstractJob
extends QuartzJobBean
implements LocaleProvider {
    public static final String DEFAULT_SESSION_FACTORY_BEAN_NAME = "sessionFactory";
    private static final Log log = LogFactory.getLog(AbstractJob.class);
    protected List textProviders = new ArrayList();
    private ApplicationConfiguration applicationConfig;
    private SessionFactory sessionFactory;

    public AbstractJob() {
        ResourceBundle b = this.getResourceBundle();
        if (b != null) {
            this.textProviders.add(new TextProviderSupport(b, (LocaleProvider)this));
        }
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setApplicationConfig(ApplicationConfiguration applicationConfig) {
        this.applicationConfig = applicationConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeInternal(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        String jobName = jobExecutionContext.getJobDetail().getName();
        if (QuartzUtil.isJobExecuting(jobExecutionContext) && !this.allowConcurrentExecution()) {
            log.info((Object)("Skipping scheduled job: " + jobName + ". It is already running."));
            return;
        }
        log.debug((Object)("Running scheduled job: " + jobName));
        if (!this.applicationConfig.isSetupComplete()) {
            log.debug((Object)("Confluence isn't setup yet, skipping job: " + jobName));
            return;
        }
        Session session = null;
        log.debug((Object)("Opening Hibernate Session for job: " + jobName));
        session = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
        session.setFlushMode(FlushMode.NEVER);
        TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)new SessionHolder(session));
        try {
            this.doExecute(jobExecutionContext);
        }
        finally {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
            log.debug((Object)("Closing Hibernate Session in for job: " + jobName));
            SessionFactoryUtils.releaseSession((Session)session, (SessionFactory)this.sessionFactory);
        }
    }

    public abstract void doExecute(JobExecutionContext var1) throws JobExecutionException;

    public ResourceBundle getResourceBundle() {
        try {
            InputStream is = ClassLoaderUtils.getResourceAsStream((String)(((Object)((Object)this)).getClass().getName().replaceAll("[.]", "/") + ".properties"), ((Object)((Object)this)).getClass());
            if (is == null) {
                return null;
            }
            return new PropertyResourceBundle(is);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected boolean allowConcurrentExecution() {
        return false;
    }

    public Locale getLocale() {
        return ActionContext.getContext() != null ? ActionContext.getContext().getLocale() : null;
    }

    public String getText(String textName) {
        TextProvider tp;
        String text = null;
        Iterator iter = this.textProviders.iterator();
        while (iter.hasNext() && (text = (tp = (TextProvider)iter.next()).getText(textName)).equals(textName)) {
        }
        return text;
    }

    public String getText(String textName, List args) {
        TextProvider tp;
        String text = null;
        Iterator iter = this.textProviders.iterator();
        while (iter.hasNext() && (text = (tp = (TextProvider)iter.next()).getText(textName, args)).equals(textName)) {
        }
        return text;
    }

    public void addAssociatedActionForResources(Class actionClass) {
        this.textProviders.add(new TextProviderSupport(actionClass, (LocaleProvider)this));
    }
}

