/*
 * Decompiled with CFR 0.152.
 */
package bucket.user.persistence.dao.hibernate;

import bucket.user.propertyset.BucketPropertySetItem;
import com.opensymphony.module.propertyset.hibernate.HibernatePropertySetDAO;
import com.opensymphony.module.propertyset.hibernate.PropertySetItem;
import java.io.Serializable;
import java.util.Collection;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.ObjectDeletedException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

public class BucketPropertySetDAO
extends HibernateDaoSupport
implements HibernatePropertySetDAO {
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void setImpl(PropertySetItem propertySetItem, boolean isUpdate) {
        if (isUpdate) {
            this.getHibernateTemplate().update((Object)propertySetItem);
        } else {
            this.getHibernateTemplate().save((Object)propertySetItem);
        }
    }

    public Collection getKeys(final String entityName, final Long entityId, final String prefix, final int type) {
        Query hibernateQuery = (Query)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = null;
                if (prefix != null && type > 0) {
                    query = session.getNamedQuery("all_keys_with_type_like");
                    query.setString("like", prefix + '%');
                    query.setInteger("type", type);
                } else if (prefix != null) {
                    query = session.getNamedQuery("all_keys_like");
                    query.setString("like", prefix + '%');
                } else if (type > 0) {
                    query = session.getNamedQuery("all_keys_with_type");
                    query.setInteger("type", type);
                } else {
                    query = session.getNamedQuery("all_keys");
                }
                query.setString("entityName", entityName);
                query.setLong("entityId", entityId.longValue());
                SessionFactoryUtils.applyTransactionTimeout((Query)query, (SessionFactory)BucketPropertySetDAO.this.getSessionFactory());
                return query;
            }
        });
        try {
            return hibernateQuery.list();
        }
        catch (HibernateException e) {
            throw SessionFactoryUtils.convertHibernateAccessException((HibernateException)e);
        }
    }

    public PropertySetItem findByKey(final String entityName, final Long entityId, final String key) {
        return (BucketPropertySetItem)((Object)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                try {
                    return session.get(BucketPropertySetItem.class, (Serializable)((Object)new BucketPropertySetItem(entityName, entityId, key)));
                }
                catch (ObjectDeletedException e) {
                    return null;
                }
            }
        }));
    }

    public void remove(String entityName, Long entityId, String key) {
        PropertySetItem item = this.findByKey(entityName, entityId, key);
        if (item == null) {
            return;
        }
        this.getHibernateTemplate().delete((Object)item);
    }
}

