/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.hazelcast;

import com.atlassian.confluence.cluster.NodeStatus;
import com.atlassian.confluence.cluster.NodeStatusImpl;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectNodeStatus
implements Callable<NodeStatus>,
Serializable {
    private static final long serialVersionUID = 7953447355233473859L;
    private static final Logger log = LoggerFactory.getLogger(CollectNodeStatus.class);
    private final String requestingMember;

    public CollectNodeStatus(String requestingMember) {
        this.requestingMember = (String)Preconditions.checkNotNull((Object)requestingMember);
    }

    @Override
    public NodeStatus call() {
        log.debug("Collecting NodeStatus for {}", (Object)this.requestingMember);
        SystemInformationService sysInfo = (SystemInformationService)ContainerManager.getInstance().getContainerContext().getComponent((Object)"systemInformationService");
        Map jvmStats = GeneralUtil.convertBeanToMap((Object)sysInfo.getMemoryInfo());
        Map props = GeneralUtil.convertBeanToMap((Object)sysInfo.getSystemProperties());
        Map buildStats = GeneralUtil.convertBeanToMap((Object)sysInfo.getConfluenceInfo());
        return new NodeStatusImpl(jvmStats, props, buildStats);
    }
}

