/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.hazelcast.hibernate;

import com.atlassian.annotations.Internal;
import com.atlassian.cache.Cache;
import com.atlassian.confluence.cache.DefaultConfluenceCache;
import com.atlassian.confluence.cache.LockingCache;
import com.atlassian.confluence.cache.hazelcast.HazelcastHelper;
import com.google.common.base.Preconditions;
import com.hazelcast.core.IMap;
import java.util.concurrent.TimeUnit;
import org.joda.time.Duration;

@Internal
public class HazelcastLockingCache<K, V>
extends DefaultConfluenceCache<K, V>
implements LockingCache<K, V> {
    private final HazelcastHelper hazelCastHelper;

    public HazelcastLockingCache(HazelcastHelper hazelCastHelper, Cache<K, V> delegate) {
        super(delegate);
        this.hazelCastHelper = (HazelcastHelper)Preconditions.checkNotNull((Object)hazelCastHelper);
    }

    public void lock(K key, Duration leaseTime) {
        IMap map = this.hazelCastHelper.getHazelcastMapForCache(this.getName());
        map.lock(key, leaseTime.getMillis(), TimeUnit.MILLISECONDS);
    }

    public void unlock(K key) {
        IMap map = this.hazelCastHelper.getHazelcastMapForCache(this.getName());
        map.unlock(key);
    }
}

