/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.hazelcast.hibernate;

import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.cache.LockingCache;
import com.atlassian.confluence.cache.hazelcast.LockingCacheManager;
import com.atlassian.confluence.cache.hazelcast.hibernate.HazelcastHibernateCache;
import com.atlassian.util.concurrent.Supplier;
import com.google.common.base.Preconditions;
import com.hazelcast.core.HazelcastInstance;
import java.util.Properties;
import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.cache.CacheProvider;

public class HazelcastHibernateCacheProvider
implements CacheProvider {
    private final Supplier<HazelcastInstance> hazelcastSupplier;
    private final LockingCacheManager lockingCacheManager;
    private final CacheSettings cacheSettings = new CacheSettingsBuilder().replicateViaCopy().build();

    public HazelcastHibernateCacheProvider(Supplier<HazelcastInstance> hazelcastSupplier, LockingCacheManager lockingCacheManager) {
        this.hazelcastSupplier = (Supplier)Preconditions.checkNotNull(hazelcastSupplier);
        this.lockingCacheManager = (LockingCacheManager)Preconditions.checkNotNull((Object)lockingCacheManager);
    }

    public Cache buildCache(String regionName, Properties ignored) throws CacheException {
        LockingCache cache = this.lockingCacheManager.getLockingCache(regionName, null, this.cacheSettings);
        return new HazelcastHibernateCache(cache, this.hazelcast().getCluster());
    }

    public long nextTimestamp() {
        HazelcastInstance instance = this.hazelcast();
        return instance.getCluster().getClusterTime();
    }

    public void start(Properties properties) throws CacheException {
    }

    public void stop() {
    }

    private HazelcastInstance hazelcast() {
        return (HazelcastInstance)Preconditions.checkNotNull((Object)this.hazelcastSupplier.get());
    }
}

